/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.advancement;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={AdvancementManager.class})
public class MixinAdvancementManager {
    @Shadow
    @Final
    private static Gson field_192783_b;

    @Redirect(method={"reload"}, at=@At(value="INVOKE", target="Lnet/minecraft/advancements/AdvancementList;loadAdvancements(Ljava/util/Map;)V"))
    private void onLoadAdvancements(AdvancementList advancementList, Map<ResourceLocation, Advancement.Builder> advancements) {
        if (!SpongeImpl.isInitialized()) {
            return;
        }
        for (PluginContainer pluginContainer : Sponge.getPluginManager().getPlugins()) {
            Path root;
            Optional<Path> optSource;
            if (pluginContainer.getId().equals("minecraft") || !(optSource = pluginContainer.getSource()).isPresent()) continue;
            Path source = optSource.get();
            String base = "assets/" + pluginContainer.getId() + "/advancements";
            if (Files.isDirectory(source, new LinkOption[0])) {
                root = source.resolve(base);
            } else {
                try {
                    FileSystem fileSystem = FileSystems.newFileSystem(source, null);
                    root = fileSystem.getPath("/" + base, new String[0]);
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("Error loading FileSystem from jar: ", (Throwable)e);
                    continue;
                }
            }
            if (!Files.exists(root, new LinkOption[0])) continue;
            try {
                Files.walk(root, new FileVisitOption[0]).forEach(path -> {
                    if (!FilenameUtils.getExtension((String)path.getFileName().toString()).equals("json")) {
                        return;
                    }
                    Path relPath = root.relativize((Path)path);
                    String id = FilenameUtils.removeExtension((String)relPath.toString()).replaceAll("\\\\", "/");
                    ResourceLocation resourceLocation = new ResourceLocation(pluginContainer.getId(), id);
                    if (!advancements.containsKey(resourceLocation)) {
                        try (BufferedReader reader = Files.newBufferedReader(path);){
                            Advancement.Builder advancementBuilder = (Advancement.Builder)JsonUtils.func_193839_a((Gson)field_192783_b, (Reader)reader, Advancement.Builder.class);
                            advancements.put(resourceLocation, advancementBuilder);
                        }
                        catch (IOException e) {
                            SpongeImpl.getLogger().error("Failed to read advancement " + resourceLocation + " from path " + path, (Throwable)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                SpongeImpl.getLogger().error("Failed to walk path: " + root, (Throwable)e);
            }
        }
        advancementList.func_192083_a(advancements);
    }
}

