/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin.asm;

import com.google.common.base.Preconditions;
import org.objectweb.asm.AnnotationVisitor;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.launch.plugin.InvalidPluginException;
import org.spongepowered.server.launch.plugin.asm.DependencyAnnotationVisitor;
import org.spongepowered.server.launch.plugin.asm.WarningAnnotationVisitor;

final class PluginAnnotationVisitor
extends WarningAnnotationVisitor {
    private final PluginMetadata metadata;
    private State state = State.DEFAULT;
    private boolean hasId;

    PluginAnnotationVisitor(String className) {
        super(327680, className);
        this.metadata = new PluginMetadata("unknown");
    }

    PluginMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    String getAnnotation() {
        return "@Plugin";
    }

    private void checkState(State state) {
        Preconditions.checkState((this.state == state ? 1 : 0) != 0, (String)"Expected state %s, but is %s", (Object)((Object)state), (Object)((Object)this.state));
    }

    @Override
    public void visit(String name, Object value) {
        if (this.state == State.AUTHORS) {
            this.metadata.addAuthor((String)value);
            return;
        }
        this.checkState(State.DEFAULT);
        Preconditions.checkNotNull((Object)name, (Object)"name");
        switch (name) {
            case "id": {
                this.hasId = true;
                this.metadata.setId((String)value);
                return;
            }
            case "name": {
                this.metadata.setName((String)value);
                return;
            }
            case "version": {
                this.metadata.setVersion((String)value);
                return;
            }
            case "description": {
                this.metadata.setDescription((String)value);
                return;
            }
            case "url": {
                this.metadata.setUrl((String)value);
                return;
            }
        }
        super.visit(name, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.state == State.DEPENDENCIES) {
            return new DependencyAnnotationVisitor(this.className, this.metadata);
        }
        return super.visitAnnotation(name, desc);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        switch (name) {
            case "authors": {
                this.state = State.AUTHORS;
                return this;
            }
            case "dependencies": {
                this.state = State.DEPENDENCIES;
                return this;
            }
        }
        return super.visitArray(name);
    }

    @Override
    public void visitEnd() {
        if (this.state != State.DEFAULT) {
            this.state = State.DEFAULT;
            return;
        }
        if (!this.hasId) {
            throw new InvalidPluginException("Plugin annotation is missing required element 'id'");
        }
    }

    private static enum State {
        DEFAULT,
        AUTHORS,
        DEPENDENCIES;

    }
}

