/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.ParrotVariant;
import org.spongepowered.api.data.type.ParrotVariants;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeParrotVariant;

public class ParrotVariantRegistryModule
implements CatalogRegistryModule<ParrotVariant> {
    public static final Map<String, ParrotVariant> PARROT_VARIANTS = Maps.newHashMap();
    public static final Map<Integer, ParrotVariant> PARROT_VARIANT_IDMAP = Maps.newHashMap();
    public static final SpongeParrotVariant RED_PARROT = new SpongeParrotVariant(0, "RED");
    public static final SpongeParrotVariant BLUE_PARROT = new SpongeParrotVariant(1, "BLUE");
    public static final SpongeParrotVariant GREEN_PARROT = new SpongeParrotVariant(2, "GREEN");
    public static final SpongeParrotVariant CYAN_PARROT = new SpongeParrotVariant(3, "CYAN");
    public static final SpongeParrotVariant GRAY_PARROT = new SpongeParrotVariant(4, "GRAY");
    @RegisterCatalog(value=ParrotVariants.class)
    private final Map<String, ParrotVariant> parrotVariantMap = new HashMap<String, ParrotVariant>();

    @Override
    public Optional<ParrotVariant> getById(String id) {
        return Optional.ofNullable(this.parrotVariantMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ParrotVariant> getAll() {
        return ImmutableList.copyOf(this.parrotVariantMap.values());
    }

    @Override
    public void registerDefaults() {
        this.parrotVariantMap.putAll(PARROT_VARIANTS);
    }

    static {
        PARROT_VARIANTS.put("red", RED_PARROT);
        PARROT_VARIANTS.put("blue", BLUE_PARROT);
        PARROT_VARIANTS.put("green", GREEN_PARROT);
        PARROT_VARIANTS.put("cyan", CYAN_PARROT);
        PARROT_VARIANTS.put("gray", GRAY_PARROT);
        PARROT_VARIANT_IDMAP.put(0, RED_PARROT);
        PARROT_VARIANT_IDMAP.put(1, BLUE_PARROT);
        PARROT_VARIANT_IDMAP.put(2, GREEN_PARROT);
        PARROT_VARIANT_IDMAP.put(3, CYAN_PARROT);
        PARROT_VARIANT_IDMAP.put(4, GRAY_PARROT);
    }
}

