/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import java.nio.file.Path;
import net.minecraft.world.WorldProvider;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.registry.type.world.DimensionTypeRegistryModule;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={net.minecraft.world.DimensionType.class})
@Implements(value={@Interface(iface=DimensionType.class, prefix="dimensionType$")})
public abstract class MixinDimensionType
implements IMixinDimensionType {
    @Shadow
    @Final
    private Class<? extends WorldProvider> field_186077_g;
    private String sanitizedId;
    private String enumName;
    private String modId;
    private Path configPath;
    private SpongeConfig<DimensionConfig> config;
    private volatile Context context;
    private boolean generateSpawnOnLoad;
    private boolean loadSpawn;

    @Shadow
    public abstract String func_186065_b();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstruct(String enumName, int ordinal, int idIn, String nameIn, String suffixIn, Class<? extends WorldProvider> clazzIn, CallbackInfo ci) {
        String dimName;
        this.enumName = dimName = enumName.toLowerCase().replace(" ", "_").replaceAll("[^A-Za-z0-9_]", "");
        this.modId = SpongeImplHooks.getModIdFromClass(clazzIn);
        this.configPath = SpongeImpl.getSpongeConfigDir().resolve("worlds").resolve(this.modId).resolve(this.enumName);
        this.config = new SpongeConfig(SpongeConfig.Type.DIMENSION, this.configPath.resolve("dimension.conf"), "sponge");
        this.loadSpawn = this.generateSpawnOnLoad = idIn == 0;
        this.config.getConfig().getWorld().setGenerateSpawnOnLoad(this.generateSpawnOnLoad);
        this.sanitizedId = this.modId + ":" + dimName;
        String contextId = this.sanitizedId.replace(":", ".");
        this.context = new Context("dimension", contextId);
        if (!WorldManager.isDimensionRegistered(idIn)) {
            DimensionTypeRegistryModule.getInstance().registerAdditionalCatalog((DimensionType)((Object)this));
        }
    }

    @Override
    public boolean shouldGenerateSpawnOnLoad() {
        return this.generateSpawnOnLoad;
    }

    @Override
    public boolean shouldLoadSpawn() {
        return this.loadSpawn;
    }

    @Override
    public void setShouldLoadSpawn(boolean keepSpawnLoaded) {
        this.loadSpawn = keepSpawnLoaded;
    }

    public String dimensionType$getId() {
        return this.sanitizedId;
    }

    @Intrinsic
    public String dimensionType$getName() {
        return this.func_186065_b();
    }

    @Override
    public String getEnumName() {
        return this.enumName;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public Path getConfigPath() {
        return this.configPath;
    }

    public Class<? extends Dimension> dimensionType$getDimensionClass() {
        return this.field_186077_g;
    }

    @Override
    public SpongeConfig<DimensionConfig> getDimensionConfig() {
        return this.config;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Overwrite
    public static net.minecraft.world.DimensionType func_186069_a(int dimensionTypeId) {
        return WorldManager.getDimensionTypeByTypeId(dimensionTypeId).orElseThrow(() -> new IllegalArgumentException("Invalid dimension id " + dimensionTypeId));
    }
}

