/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.management.PlayerList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.service.permission.SpongePermissionService;

@Mixin(value={DedicatedPlayerList.class})
public abstract class MixinDedicatedPlayerList
extends PlayerList {
    public MixinDedicatedPlayerList(MinecraftServer server) {
        super(server);
    }

    @Inject(method={"canJoin"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanJoin(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        if (!this.func_72383_n() || this.func_152599_k().func_152705_a(profile)) {
            ci.setReturnValue(true);
            return;
        }
        PermissionService permissionService = Sponge.getServiceManager().provideUnchecked(PermissionService.class);
        Subject subject = permissionService.getUserSubjects().getSubject(profile.getId().toString()).orElse(permissionService.getDefaults());
        ci.setReturnValue(subject.hasPermission("minecraft.login.bypass-whitelist"));
    }

    @Inject(method={"bypassesPlayerLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBypassPlayerLimit(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        PermissionService permissionService = Sponge.getServiceManager().provideUnchecked(PermissionService.class);
        Subject subject = permissionService.getUserSubjects().getSubject(profile.getId().toString()).orElse(permissionService.getDefaults());
        Tristate tristate = subject.getPermissionValue(SubjectData.GLOBAL_CONTEXT, "minecraft.login.bypass-player-limit");
        if (tristate == Tristate.UNDEFINED && permissionService instanceof SpongePermissionService) {
            return;
        }
        ci.setReturnValue(tristate.asBoolean());
    }
}

