/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancement;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.PlayerAdvancements;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.Progressable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.advancement.ICriterionProgress;
import org.spongepowered.common.advancement.SpongeAndCriterion;
import org.spongepowered.common.advancement.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.SpongeScoreCriterion;
import org.spongepowered.common.advancement.SpongeScoreCriterionProgress;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancementProgress;
import org.spongepowered.common.interfaces.advancement.IMixinCriterion;
import org.spongepowered.common.interfaces.advancement.IMixinCriterionProgress;
import org.spongepowered.common.interfaces.advancement.IMixinPlayerAdvancements;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;

@Mixin(value={AdvancementProgress.class})
public class MixinAdvancementProgress
implements org.spongepowered.api.advancement.AdvancementProgress,
IMixinAdvancementProgress {
    @Shadow
    @Final
    private Map<String, net.minecraft.advancements.CriterionProgress> field_192110_a;
    @Nullable
    private Map<AdvancementCriterion, ICriterionProgress> progressMap;
    @Nullable
    private String advancement;
    @Nullable
    private PlayerAdvancements playerAdvancements;

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void onUpdate(Map<String, Criterion> criteriaIn, String[][] requirements, CallbackInfo ci) {
        this.progressMap = null;
        if (this.advancement != null) {
            this.getProgressMap();
        }
    }

    private Map<AdvancementCriterion, ICriterionProgress> getProgressMap() {
        if (this.progressMap == null) {
            this.progressMap = new HashMap<AdvancementCriterion, ICriterionProgress>();
            this.processProgressMap(this.getAdvancement().getCriterion(), this.progressMap);
        }
        return this.progressMap;
    }

    private void processProgressMap(AdvancementCriterion criterion, Map<AdvancementCriterion, ICriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).getCriteria().forEach(child -> this.processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion, new SpongeAndCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)this, (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion, new SpongeOrCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)this, (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                IMixinCriterionProgress progress = (IMixinCriterionProgress)this.field_192110_a.get(advancementCriterion.getName());
                progress.setCriterion(advancementCriterion);
                progressMap.put(advancementCriterion, (ICriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion, new SpongeScoreCriterionProgress(this, scoreCriterion));
        } else if (criterion != SpongeEmptyCriterion.INSTANCE) {
            IMixinCriterionProgress progress = (IMixinCriterionProgress)this.field_192110_a.get(criterion.getName());
            progress.setCriterion(criterion);
            progressMap.put(criterion, (ICriterionProgress)((Object)progress));
        }
    }

    @Overwrite
    public boolean func_192105_a() {
        return this.get(this.getAdvancement().getCriterion()).map(Progressable::achieved).orElse(false);
    }

    @Overwrite
    public boolean func_192109_a(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192153_b();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((IMixinPlayerAdvancements)this.playerAdvancements).getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.get(scoreCriterion).get();
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant(cause, this.getAdvancement(), criterion, player, Instant.now());
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192153_b();
        return true;
    }

    @Overwrite
    public boolean func_192101_b(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || !criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192154_c();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((IMixinPlayerAdvancements)this.playerAdvancements).getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.get(scoreCriterion).get();
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke(cause, this.getAdvancement(), criterion, player);
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192154_c();
        return true;
    }

    @Override
    public PlayerAdvancements getPlayerAdvancements() {
        Preconditions.checkState((this.playerAdvancements != null ? 1 : 0) != 0, (Object)"The playerAdvancements is not yet initialized");
        return this.playerAdvancements;
    }

    @Override
    public void setPlayerAdvancements(PlayerAdvancements playerAdvancements) {
        this.getProgressMap();
        this.playerAdvancements = playerAdvancements;
    }

    @Override
    public void setAdvancement(String advancement) {
        this.advancement = advancement;
    }

    @Override
    public void invalidateAchievedState() {
        for (ICriterionProgress progress : this.progressMap.values()) {
            progress.invalidateAchievedState();
        }
    }

    @Override
    public Advancement getAdvancement() {
        Preconditions.checkState((this.advancement != null ? 1 : 0) != 0, (Object)"The advancement is not yet initialized");
        return (Advancement)AdvancementRegistryModule.getInstance().getById(this.advancement).get();
    }

    @Override
    public Optional<ScoreCriterionProgress> get(ScoreAdvancementCriterion criterion) {
        return Optional.ofNullable((ScoreCriterionProgress)((Object)this.getProgressMap().get(criterion)));
    }

    @Override
    public Optional<CriterionProgress> get(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        return Optional.ofNullable(this.getProgressMap().get(criterion));
    }

    @Override
    public Optional<Instant> get() {
        return this.get(this.getAdvancement().getCriterion()).get().get();
    }

    @Override
    public Instant grant() {
        return this.get(this.getAdvancement().getCriterion()).get().grant();
    }

    @Override
    public Optional<Instant> revoke() {
        return this.get(this.getAdvancement().getCriterion()).get().revoke();
    }
}

