/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.lens.Lens;

public final class LensHandle<TInventory, TStack> {
    public Lens<TInventory, TStack> lens;
    public int ordinal = -1;
    private Collection<InventoryProperty<?, ?>> properties;

    public LensHandle() {
        this(null, new InventoryProperty[0]);
    }

    public LensHandle(Lens<TInventory, TStack> lens, InventoryProperty<?, ?> ... properties) {
        this.lens = lens;
        if (properties != null && properties.length > 0) {
            this.properties = new ArrayList();
            Collections.addAll(this.properties, properties);
        }
    }

    public LensHandle(Lens<TInventory, TStack> lens, Collection<InventoryProperty<?, ?>> properties) {
        this.lens = lens;
        if (properties != null && properties.size() > 0) {
            this.properties = new ArrayList(properties);
        }
    }

    public Collection<InventoryProperty<?, ?>> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.properties);
    }

    public <T, K, V> InventoryProperty<K, V> getProperty(Class<T> property) {
        return this.getProperty(property, null);
    }

    public <T, K, V> InventoryProperty<K, V> getProperty(Class<T> property, Object key) {
        if (this.properties != null) {
            for (InventoryProperty<?, ?> prop : this.properties) {
                if (!prop.getClass().equals(property) || key != null && !key.equals(prop.getKey())) continue;
                return prop;
            }
        }
        return null;
    }

    public void setProperty(InventoryProperty<?, ?> property) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        } else {
            this.removeMatchingProperties(property);
        }
        this.properties.add(property);
    }

    public void removeProperty(InventoryProperty<?, ?> property) {
        if (this.properties != null) {
            this.removeMatchingProperties(property);
        }
    }

    private void removeMatchingProperties(InventoryProperty<?, ?> property) {
        Iterator<InventoryProperty<?, ?>> iter = this.properties.iterator();
        while (iter.hasNext()) {
            InventoryProperty<?, ?> prop = iter.next();
            if (prop.getClass() != property.getClass() || !prop.getKey().equals(property.getKey())) continue;
            iter.remove();
        }
    }
}

