/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.comp;

import com.flowpowered.math.vector.Vector2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.item.inventory.type.InventoryColumn;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryColumnLens;
import org.spongepowered.common.item.inventory.lens.comp.InventoryRowLens;

public class GridInventoryAdapter
extends Inventory2DAdapter
implements GridInventory {
    protected final GridInventoryLens<IInventory, net.minecraft.item.ItemStack> gridLens;
    protected final List<InventoryRow> rows = new ArrayList<InventoryRow>();
    protected final List<InventoryColumn> columns = new ArrayList<InventoryColumn>();

    public GridInventoryAdapter(Fabric<IInventory> inventory, GridInventoryLens<IInventory, net.minecraft.item.ItemStack> root) {
        this(inventory, root, (Inventory)null);
    }

    public GridInventoryAdapter(Fabric<IInventory> inventory, GridInventoryLens<IInventory, net.minecraft.item.ItemStack> root, Inventory parent) {
        super(inventory, (Inventory2DLens<IInventory, net.minecraft.item.ItemStack>)root, parent);
        this.gridLens = root;
    }

    @Override
    public int getColumns() {
        return this.lens2d.getWidth();
    }

    @Override
    public int getRows() {
        return this.lens2d.getHeight();
    }

    @Override
    public Vector2i getDimensions() {
        return new Vector2i(this.getColumns(), this.getRows());
    }

    @Override
    public Optional<Slot> getSlot(int x, int y) {
        return VanillaAdapter.forSlot(this.inventory, this.getSlotLens(x, y), this);
    }

    @Override
    public Optional<InventoryRow> getRow(int y) {
        try {
            InventoryRowLens<IInventory, net.minecraft.item.ItemStack> rowLens = this.gridLens.getRow(y);
            return Optional.ofNullable((InventoryRow)((Object)rowLens.getAdapter(this.inventory, this)));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<InventoryColumn> getColumn(int x) {
        try {
            InventoryColumnLens<IInventory, net.minecraft.item.ItemStack> columnLens = this.gridLens.getColumn(x);
            return Optional.ofNullable((InventoryColumn)((Object)columnLens.getAdapter(this.inventory, this)));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<ItemStack> poll(int x, int y) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(x, y));
    }

    @Override
    public Optional<ItemStack> poll(int x, int y, int limit) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(x, y), limit);
    }

    @Override
    public Optional<ItemStack> peek(int x, int y) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(x, y));
    }

    @Override
    public Optional<ItemStack> peek(int x, int y, int limit) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(x, y), limit);
    }

    @Override
    public InventoryTransactionResult set(int x, int y, ItemStack stack) {
        return AdapterLogic.insertSequential(this.inventory, this.getSlotLens(x, y), stack);
    }
}

