/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class SlotCollectionIterator<TInventory>
implements Iterable<Slot> {
    private Inventory parent;
    private final Fabric<TInventory> inv;
    private final List<Slot> slots;

    public SlotCollectionIterator(Inventory parent, Fabric<TInventory> inv, Lens<TInventory, ItemStack> lens, SlotProvider<IInventory, ItemStack> slots) {
        this.parent = parent;
        this.inv = inv;
        this.slots = this.traverseSpanningTree(inv, lens, slots, (ImmutableList.Builder<Slot>)ImmutableList.builder()).build();
    }

    private ImmutableList.Builder<Slot> traverseSpanningTree(Fabric<TInventory> inv, Lens<TInventory, ItemStack> lens, SlotProvider<IInventory, ItemStack> slots, ImmutableList.Builder<Slot> list) {
        for (Lens<TInventory, ItemStack> child : lens.getSpanningChildren()) {
            if (child instanceof SlotLens) {
                list.add((Object)((SlotAdapter)child.getAdapter(inv, this.parent)));
                continue;
            }
            if (child.getSpanningChildren().size() <= 0) continue;
            this.traverseSpanningTree(inv, child, slots, list);
        }
        return list;
    }

    public Fabric<TInventory> getFabric() {
        return this.inv;
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.slots.iterator();
    }
}

