/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.ItemsHelper;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;

public class SpongeItemStackBuilder
extends AbstractDataBuilder<ItemStack>
implements ItemStack.Builder {
    @Nullable
    private Set<DataManipulator<?, ?>> itemDataSet;
    private ItemType type;
    private int quantity;
    private int damageValue = 0;
    @Nullable
    private LinkedHashMap<Key<?>, Object> keyValues;
    @Nullable
    private NBTTagCompound compound;

    public SpongeItemStackBuilder() {
        super(ItemStack.class, 1);
        this.reset();
    }

    @Override
    public ItemStack.Builder itemType(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType, (Object)"Item type cannot be null");
        this.type = itemType;
        return this;
    }

    @Override
    public ItemType getCurrentItem() {
        return this.type == null ? ItemTypes.NONE : this.type;
    }

    @Override
    public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0, (Object)"Quantity must not be smaller than 0");
        this.quantity = quantity;
        return this;
    }

    @Override
    public ItemStack.Builder itemData(ImmutableDataManipulator<?, ?> itemData) throws IllegalArgumentException {
        return this.itemData((DataManipulator<?, ?>)itemData.asMutable());
    }

    @Override
    public <V> ItemStack.Builder add(Key<? extends BaseValue<V>> key, V value) throws IllegalArgumentException {
        if (this.keyValues == null) {
            this.keyValues = new LinkedHashMap();
        }
        this.keyValues.put((Key<?>)Preconditions.checkNotNull(key, (Object)"Key cannot be null!"), Preconditions.checkNotNull(value, (Object)"Value cannot be null!"));
        return this;
    }

    @Override
    public ItemStack.Builder itemData(DataManipulator<?, ?> itemData) throws IllegalArgumentException {
        Preconditions.checkNotNull(itemData, (Object)"Must have a non-null item data!");
        Preconditions.checkNotNull((Object)this.type, (Object)"Cannot set item data without having set a type first!");
        DataTransactionResult result = ItemsHelper.validateData(this.type, itemData);
        if (result.getType() != DataTransactionResult.Type.SUCCESS) {
            throw new IllegalArgumentException("The item data is not compatible with the current item type!");
        }
        if (this.itemDataSet == null) {
            this.itemDataSet = new HashSet();
        }
        this.itemDataSet.add(itemData);
        return this;
    }

    @Override
    public ItemStack.Builder fromItemStack(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"Item stack cannot be null");
        this.itemDataSet = new HashSet();
        this.type = itemStack.getType();
        this.quantity = itemStack.getQuantity();
        if (itemStack instanceof net.minecraft.item.ItemStack) {
            this.damageValue = ((net.minecraft.item.ItemStack)itemStack).func_77952_i();
            NBTTagCompound itemCompound = ((net.minecraft.item.ItemStack)itemStack).func_77978_p();
            if (itemCompound != null) {
                this.compound = itemCompound.func_74737_b();
            }
            this.itemDataSet.addAll(((IMixinCustomDataHolder)((Object)itemStack)).getCustomManipulators());
        } else {
            this.itemDataSet.addAll(itemStack.getContainers());
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromContainer(DataView container) {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(DataQueries.ITEM_TYPE) && container.contains(DataQueries.ITEM_COUNT) && container.contains(DataQueries.ITEM_DAMAGE_VALUE))) {
            return this;
        }
        this.reset();
        int count = DataUtil.getData(container, DataQueries.ITEM_COUNT, Integer.class);
        this.quantity(count);
        String itemTypeId = DataUtil.getData(container, DataQueries.ITEM_TYPE, String.class);
        ItemType itemType = SpongeImpl.getRegistry().getType(ItemType.class, itemTypeId).get();
        this.itemType(itemType);
        this.damageValue = DataUtil.getData(container, DataQueries.ITEM_DAMAGE_VALUE, Integer.class);
        if (container.contains(DataQueries.UNSAFE_NBT)) {
            NBTTagCompound compound = NbtTranslator.getInstance().translateData(container.getView(DataQueries.UNSAFE_NBT).get());
            if (compound.func_150297_b("SpongeData", 10)) {
                compound.func_82580_o("SpongeData");
            }
            this.compound = compound;
        }
        if (container.contains(DataQueries.DATA_MANIPULATORS)) {
            List<DataView> views = container.getViewList(DataQueries.DATA_MANIPULATORS).get();
            SerializedDataTransaction transaction = DataUtil.deserializeManipulatorList(views);
            ImmutableList<DataManipulator<?, ?>> manipulators = transaction.deserializedManipulators;
            this.itemDataSet = new HashSet();
            manipulators.forEach(this.itemDataSet::add);
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"The snapshot was null!");
        this.itemType(snapshot.getType());
        this.quantity(snapshot.getQuantity());
        for (ImmutableDataManipulator manipulator : snapshot.getContainers()) {
            this.itemData(manipulator);
        }
        if (snapshot instanceof SpongeItemStackSnapshot) {
            this.damageValue = ((SpongeItemStackSnapshot)snapshot).getDamageValue();
            Optional<NBTTagCompound> compoundOptional = ((SpongeItemStackSnapshot)snapshot).getCompound();
            this.compound = compoundOptional.isPresent() ? compoundOptional.get() : null;
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
        Preconditions.checkNotNull((Object)blockSnapshot, (Object)"The snapshot was null!");
        this.reset();
        BlockType blockType = blockSnapshot.getState().getType();
        Optional<ItemType> itemType = blockType.getItem();
        this.itemType(itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + blockType.getId())));
        this.quantity(1);
        if (blockSnapshot instanceof SpongeBlockSnapshot) {
            Block block = (Block)blockType;
            this.damageValue = block.func_180651_a((IBlockState)blockSnapshot.getState());
            Optional<NBTTagCompound> compound = ((SpongeBlockSnapshot)blockSnapshot).getCompound();
            if (compound.isPresent()) {
                this.compound = new NBTTagCompound();
                this.compound.func_74782_a("BlockEntityTag", (NBTBase)compound.get());
            }
        } else {
            blockSnapshot.getContainers().forEach(this::itemData);
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromBlockState(BlockState blockState) {
        IBlockState minecraftState = BlockUtil.toNative(blockState);
        Optional<ItemType> item = blockState.getType().getItem();
        if (!item.isPresent()) {
            new PrettyPrinter(60).add("Invalid BlockState").centre().hr().add("Someone attempted to create an ItemStack from a BlockState that does not have a valid item!").add("%s : %s", "BlockState", blockState).add("%s : %s", "BlockType", blockState.getType()).add(new Exception("Stacktrace")).trace();
            return this;
        }
        this.itemType(item.get());
        this.damageValue = minecraftState.func_177230_c().func_180651_a(minecraftState);
        return this;
    }

    @Override
    public ItemStack.Builder remove(Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        if (this.itemDataSet != null) {
            Iterator<DataManipulator<?, ?>> iterator = this.itemDataSet.iterator();
            while (iterator.hasNext()) {
                DataManipulator<?, ?> next = iterator.next();
                if (!manipulatorClass.isInstance(next)) continue;
                iterator.remove();
                break;
            }
        }
        return this;
    }

    @Override
    public ItemStack.Builder from(ItemStack value) {
        return this.fromItemStack(value);
    }

    @Override
    protected Optional<ItemStack> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(DataQueries.ITEM_TYPE) && container.contains(DataQueries.ITEM_COUNT) && container.contains(DataQueries.ITEM_DAMAGE_VALUE))) {
            return Optional.empty();
        }
        String itemTypeId = DataUtil.getData(container, DataQueries.ITEM_TYPE, String.class);
        int count = DataUtil.getData(container, DataQueries.ITEM_COUNT, Integer.class);
        ItemType itemType = SpongeImpl.getRegistry().getType(ItemType.class, itemTypeId).get();
        int damage = DataUtil.getData(container, DataQueries.ITEM_DAMAGE_VALUE, Integer.class);
        net.minecraft.item.ItemStack itemStack = new net.minecraft.item.ItemStack((Item)itemType, count, damage);
        if (container.contains(DataQueries.UNSAFE_NBT)) {
            NBTTagCompound compound = NbtTranslator.getInstance().translateData(container.getView(DataQueries.UNSAFE_NBT).get());
            itemStack.func_77982_d(compound);
        }
        if (container.contains(DataQueries.DATA_MANIPULATORS)) {
            List<DataView> views = container.getViewList(DataQueries.DATA_MANIPULATORS).get();
            SerializedDataTransaction transaction = DataUtil.deserializeManipulatorList(views);
            ImmutableList<DataManipulator<?, ?>> manipulators = transaction.deserializedManipulators;
            for (DataManipulator manipulator : manipulators) {
                ((IMixinCustomDataHolder)itemStack).offerCustom(manipulator, MergeFunction.IGNORE_ALL);
            }
            if (!transaction.failedData.isEmpty()) {
                ((IMixinCustomDataHolder)itemStack).addFailedData(transaction.failedData);
            }
        }
        return Optional.of((ItemStack)itemStack);
    }

    @Override
    public ItemStack.Builder reset() {
        this.type = null;
        this.quantity = 1;
        this.itemDataSet = new HashSet();
        this.compound = null;
        this.damageValue = 0;
        return this;
    }

    @Override
    public ItemStack build() throws IllegalStateException {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Item type has not been set");
        if (this.type == ItemTypes.NONE || this.quantity <= 0) {
            return (ItemStack)net.minecraft.item.ItemStack.field_190927_a;
        }
        ItemStack stack = (ItemStack)new net.minecraft.item.ItemStack((Item)this.type, this.quantity, this.damageValue);
        if (this.compound != null) {
            ((net.minecraft.item.ItemStack)stack).func_77982_d(this.compound.func_74737_b());
        }
        if (this.itemDataSet != null) {
            this.itemDataSet.forEach(stack::offer);
        }
        if (this.keyValues != null) {
            this.keyValues.entrySet().forEach(entry -> stack.offer((Key)entry.getKey(), entry.getValue()));
        }
        return stack;
    }
}

