/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public abstract class PacketState<P extends PacketContext<P>>
implements IPhaseState<P> {
    private final String className = this.getClass().getSimpleName();

    PacketState() {
    }

    protected static void processSpawnedEntities(EntityPlayerMP player, SpawnEntityEvent event) {
        List<org.spongepowered.api.entity.Entity> entities = event.getEntities();
        PacketState.processEntities(player, entities);
    }

    protected static void processEntities(EntityPlayerMP player, Collection<org.spongepowered.api.entity.Entity> entities) {
        for (org.spongepowered.api.entity.Entity entity : entities) {
            entity.setCreator(player.func_110124_au());
            EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
        }
    }

    @Override
    public final TrackingPhase getPhase() {
        return TrackingPhases.PACKET;
    }

    @Override
    public void unwind(P phaseContext) {
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void addNotifierToBlockEvent(P context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        Player player = ((PacketContext)unwindingContext).getSpongePlayer();
        ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).setBlockNotifier(notifyPos, player.getUniqueId());
    }

    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, P context) {
    }

    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        return false;
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return false;
    }

    @Override
    public boolean doesCaptureEntityDrops() {
        return false;
    }

    @Override
    public boolean requiresBlockCapturing() {
        return true;
    }

    @Override
    public void postProcessSpawns(P phaseContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        Player player = ((PacketContext)phaseContext).getSpongePlayer();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            Sponge.getCauseStackManager().pushCause(player);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        }
    }

    @Override
    public boolean spawnEntityOrCapture(P context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        return this.shouldCaptureEntity() ? ((PhaseContext)context).getCapturedEntities().add(entity) : this.spawnEntity(context, entity, chunkX, chunkZ);
    }

    public boolean shouldCaptureEntity() {
        return false;
    }

    public boolean spawnEntity(P context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Entity minecraftEntity = (Entity)entity;
        WorldServer minecraftWorld = (WorldServer)minecraftEntity.field_70170_p;
        Player player = ((PhaseContext)context).getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a player", context));
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, player);
            Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, player);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity newEntity : event.getEntities()) {
                    EntityUtil.toMixin(newEntity).setCreator(player.getUniqueId());
                    ((IMixinWorldServer)minecraftWorld).forceSpawnEntity(newEntity);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String toString() {
        return this.getPhase() + "{" + this.className + "}";
    }
}

