/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;

public final class ExplosionContext
extends GeneralPhaseContext<ExplosionContext> {
    private Explosion explosion;

    public ExplosionContext() {
        super(GeneralPhase.State.EXPLOSION);
    }

    public ExplosionContext populateFromCurrentState() {
        PhaseData currentPhaseData = PhaseTracker.getInstance().getCurrentPhaseData();
        currentPhaseData.state.appendContextPreExplosion(this, currentPhaseData.context);
        return this;
    }

    public ExplosionContext potentialExplosionSource(WorldServer worldServer, @Nullable Entity entityIn) {
        if (entityIn != null) {
            this.source(entityIn);
        } else {
            this.source(worldServer);
        }
        return this;
    }

    public ExplosionContext explosion(Explosion explosion) {
        this.explosion = explosion;
        return this;
    }

    public Explosion getExplosion() {
        return this.explosion;
    }

    public org.spongepowered.api.world.explosion.Explosion getSpongeExplosion() {
        return (org.spongepowered.api.world.explosion.Explosion)this.explosion;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer) {
        return super.printCustom(printer).add("    - %s: %s", "Explosion", this.explosion);
    }
}

