/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.DimensionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.plugin.blockcapturing.IModData_BlockCapturing;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeProxyBlockAccess;

public final class TrackingUtil {
    public static final int BREAK_BLOCK_INDEX = 0;
    public static final int PLACE_BLOCK_INDEX = 1;
    public static final int DECAY_BLOCK_INDEX = 2;
    public static final int CHANGE_BLOCK_INDEX = 3;
    public static final int MULTI_CHANGE_INDEX = 4;
    public static final Function<ImmutableList.Builder<Transaction<BlockSnapshot>>[], Consumer<Transaction<BlockSnapshot>>> TRANSACTION_PROCESSOR = builders -> transaction -> {
        BlockChange blockChange = ((SpongeBlockSnapshot)transaction.getOriginal()).blockChange;
        builders[blockChange.ordinal()].add(transaction);
        builders[4].add(transaction);
    };
    public static final int EVENT_COUNT = 5;
    public static final Function<BlockSnapshot, Transaction<BlockSnapshot>> TRANSACTION_CREATION = blockSnapshot -> {
        Location<World> originalLocation = blockSnapshot.getLocation().get();
        WorldServer worldServer = (WorldServer)originalLocation.getExtent();
        BlockPos blockPos = ((IMixinLocation)((Object)originalLocation)).getBlockPos();
        IBlockState newState = worldServer.func_180495_p(blockPos);
        IBlockState newActualState = newState.func_185899_b((IBlockAccess)worldServer, blockPos);
        SpongeBlockSnapshot newSnapshot = ((IMixinWorldServer)worldServer).createSpongeBlockSnapshot(newState, newActualState, blockPos, BlockChangeFlags.NONE);
        return new Transaction<SpongeBlockSnapshot>((SpongeBlockSnapshot)blockSnapshot, newSnapshot);
    };

    public static void tickEntity(net.minecraft.entity.Entity entityIn) {
        Preconditions.checkArgument((boolean)(entityIn instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entityIn);
        Preconditions.checkNotNull((Object)entityIn, (Object)"Cannot capture on a null ticking entity!");
        IMixinEntity mixinEntity = EntityUtil.toMixin(entityIn);
        if (!mixinEntity.shouldTick()) {
            return;
        }
        EntityTickContext tickContext = (EntityTickContext)TickPhase.Tick.ENTITY.createPhaseContext().source(entityIn);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             EntityTickContext context = tickContext;
             Timing entityTiming = mixinEntity.getTimingsHandler().startTiming();){
            Sponge.getCauseStackManager().pushCause(entityIn);
            mixinEntity.getNotifierUser().ifPresent(notifier -> {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier);
                context.notifier((User)notifier);
            });
            mixinEntity.getCreatorUser().ifPresent(notifier -> {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, notifier);
                context.owner((User)notifier);
            });
            context.buildAndSwitch();
            entityIn.func_70071_h_();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickRidingEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        if (!mixinEntity.shouldTick()) {
            return;
        }
        Optional<User> notifierUser = mixinEntity.getNotifierUser();
        Optional<User> creatorUser = mixinEntity.getCreatorUser();
        EntityTickContext tickContext = (EntityTickContext)((EntityTickContext)((EntityTickContext)TickPhase.Tick.ENTITY.createPhaseContext().source(entity)).notifier(() -> notifierUser)).owner(() -> creatorUser);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             EntityTickContext context = (EntityTickContext)tickContext.buildAndSwitch();
             Timing entityTiming = mixinEntity.getTimingsHandler().startTiming();){
            Sponge.getCauseStackManager().pushCause(entity);
            notifierUser.ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            creatorUser.ifPresent(notifier -> frame.addContext(EventContextKeys.OWNER, notifier));
            entity.func_70098_U();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickTileEntity(IMixinWorldServer mixinWorldServer, ITickable tile) {
        Preconditions.checkArgument((boolean)(tile instanceof org.spongepowered.api.block.tileentity.TileEntity), (String)"ITickable %s is not a TileEntity!", (Object)tile);
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        TileEntity tileEntity = (TileEntity)tile;
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)tile;
        BlockPos pos = tileEntity.func_174877_v();
        IMixinChunk chunk = ((IMixinTileEntity)tile).getActiveChunk();
        if (!mixinTileEntity.shouldTick()) {
            return;
        }
        TileEntityTickContext context = (TileEntityTickContext)TickPhase.Tick.TILE_ENTITY.createPhaseContext().source(tile);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             TileEntityTickContext phaseContext = context;){
            Sponge.getCauseStackManager().pushCause(tile);
            chunk.getBlockNotifier(pos).ifPresent(notifier -> {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier);
                phaseContext.notifier((User)notifier);
            });
            User blockOwner = mixinTileEntity.getSpongeOwner();
            if (!mixinTileEntity.hasSetOwner()) {
                blockOwner = chunk.getBlockOwner(pos).orElse(null);
                mixinTileEntity.setSpongeOwner(blockOwner);
            }
            if (blockOwner != null) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, blockOwner);
                phaseContext.owner(blockOwner);
            }
            phaseContext.owner = blockOwner;
            phaseContext.buildAndSwitch();
            try (Timing timing = mixinTileEntity.getTimingsHandler().startTiming();){
                tile.func_73660_a();
            }
        }
        catch (Exception e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, context);
        }
    }

    public static void updateTickBlock(IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(minecraftWorld);
            if (ShouldFire.TICK_BLOCK_EVENT) {
                SpongeBlockSnapshot snapshot = mixinWorld.createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.NONE);
                TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(Sponge.getCauseStackManager().getCurrentCause(), snapshot);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    return;
                }
            }
            LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>(mixinWorld.asSpongeWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
            Sponge.getCauseStackManager().pushCause(locatable);
            IPhaseState<BlockTickContext> phase = ((IMixinBlock)block).requiresBlockCapture() ? TickPhase.Tick.BLOCK : TickPhase.Tick.NO_CAPTURE_BLOCK;
            BlockTickContext phaseContext = (BlockTickContext)phase.createPhaseContext().source(locatable);
            TrackingUtil.checkAndAssignBlockTickConfig(block, minecraftWorld, phaseContext);
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            PhaseData current = phaseTracker.getCurrentPhaseData();
            IPhaseState<?> currentState = current.state;
            currentState.appendNotifierPreBlockTick(mixinWorld, pos, current.context, phaseContext);
            try (Object context = phaseContext.buildAndSwitch();){
                block.func_180650_b((net.minecraft.world.World)minecraftWorld, pos, state, random);
            }
            catch (Exception | NoClassDefFoundError e) {
                phaseTracker.printExceptionFromPhase(e, phaseContext);
            }
        }
    }

    public static void randomTickBlock(PhaseTracker phaseTracker, IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(minecraftWorld);
            if (ShouldFire.TICK_BLOCK_EVENT) {
                SpongeBlockSnapshot currentTickBlock = mixinWorld.createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.NONE);
                TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(Sponge.getCauseStackManager().getCurrentCause(), currentTickBlock);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) {
                    return;
                }
            }
            LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>(mixinWorld.asSpongeWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
            Sponge.getCauseStackManager().pushCause(locatable);
            IPhaseState<BlockTickContext> phase = ((IMixinBlock)block).requiresBlockCapture() ? TickPhase.Tick.RANDOM_BLOCK : TickPhase.Tick.NO_CAPTURE_BLOCK;
            BlockTickContext phaseContext = (BlockTickContext)phase.createPhaseContext().source(locatable);
            TrackingUtil.checkAndAssignBlockTickConfig(block, minecraftWorld, phaseContext);
            PhaseData current = phaseTracker.getCurrentPhaseData();
            IPhaseState<?> currentState = current.state;
            currentState.appendNotifierPreBlockTick(mixinWorld, pos, current.context, phaseContext);
            try (Object context = phaseContext.buildAndSwitch();){
                block.func_180645_a((net.minecraft.world.World)minecraftWorld, pos, state, random);
            }
            catch (Exception | NoClassDefFoundError e) {
                phaseTracker.printExceptionFromPhase(e, phaseContext);
            }
        }
    }

    private static void checkAndAssignBlockTickConfig(Block block, WorldServer minecraftWorld, PhaseContext<?> phaseContext) {
        IModData_BlockCapturing capturingBlock;
        if (block instanceof IModData_BlockCapturing && (capturingBlock = (IModData_BlockCapturing)block).requiresBlockCapturingRefresh()) {
            capturingBlock.initializeBlockCapturingState((net.minecraft.world.World)minecraftWorld);
            capturingBlock.requiresBlockCapturingRefresh(false);
        }
    }

    public static void tickWorldProvider(IMixinWorldServer worldServer) {
        WorldProvider worldProvider = ((WorldServer)worldServer).field_73011_w;
        try (DimensionContext context = (DimensionContext)((DimensionContext)TickPhase.Tick.DIMENSION.createPhaseContext().source(worldProvider)).buildAndSwitch();){
            worldProvider.func_186059_r();
        }
    }

    public static boolean fireMinecraftBlockEvent(WorldServer worldIn, BlockEventData event) {
        DataSerializable source;
        IBlockState currentState = worldIn.func_180495_p(event.func_180328_a());
        IMixinBlockEventData blockEvent = (IMixinBlockEventData)event;
        IPhaseState<TickContext> phase = blockEvent.getCaptureBlocks() ? TickPhase.Tick.BLOCK_EVENT : TickPhase.Tick.NO_CAPTURE_BLOCK;
        TickContext phaseContext = phase.createPhaseContext();
        DataSerializable dataSerializable = source = blockEvent.getTickBlock() != null ? blockEvent.getTickBlock() : blockEvent.getTickTileEntity();
        if (source == null) {
            boolean result = currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
            return result;
        }
        phaseContext.source(source);
        if (blockEvent.getSourceUser() != null) {
            phaseContext.notifier(blockEvent.getSourceUser());
        }
        try (Object o = phaseContext.buildAndSwitch();){
            boolean bl = currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
            return bl;
        }
    }

    static boolean trackBlockChange(PhaseTracker phaseTracker, IMixinWorldServer mixinWorld, Chunk chunk, IBlockState currentState, IBlockState newState, BlockPos pos, BlockChangeFlag flags, PhaseContext<?> phaseContext, IPhaseState<?> phaseState) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        if (phaseState.shouldCaptureBlockChangeOrSkip(phaseContext, pos)) {
            SpongeBlockSnapshot originalBlockSnapshot = mixinWorld.createSpongeBlockSnapshot(currentState, currentState, pos, flags);
            List<BlockSnapshot> capturedSnapshots = phaseContext.getCapturedBlocks();
            Block newBlock = newState.func_177230_c();
            TrackingUtil.associateBlockChangeWithSnapshot(phaseState, newBlock, currentState, originalBlockSnapshot, capturedSnapshots);
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot);
            if (originalBlockState == null) {
                capturedSnapshots.remove(originalBlockSnapshot);
                return false;
            }
            phaseState.postTrackBlock(originalBlockSnapshot, phaseTracker, phaseContext);
        } else {
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            SpongeBlockSnapshot originalBlockSnapshot = (SpongeBlockSnapshot)BlockSnapshot.NONE;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot);
            if (originalBlockState == null) {
                return false;
            }
        }
        if (newState.func_185891_c() != currentState.func_185891_c() || newState.func_185906_d() != currentState.func_185906_d()) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        return true;
    }

    private static void associateBlockChangeWithSnapshot(IPhaseState<?> phaseState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, List<BlockSnapshot> capturedSnapshots) {
        Block originalBlock = currentState.func_177230_c();
        if (phaseState == BlockPhase.State.BLOCK_DECAY) {
            if (newBlock == Blocks.field_150350_a) {
                snapshot.blockChange = BlockChange.DECAY;
                capturedSnapshots.add(snapshot);
            }
        } else if (newBlock == Blocks.field_150350_a) {
            snapshot.blockChange = BlockChange.BREAK;
            capturedSnapshots.add(snapshot);
        } else if (newBlock != originalBlock && !TrackingUtil.forceModify(originalBlock, newBlock)) {
            snapshot.blockChange = BlockChange.PLACE;
            capturedSnapshots.add(snapshot);
        } else {
            snapshot.blockChange = BlockChange.MODIFY;
            capturedSnapshots.add(snapshot);
        }
    }

    private static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof BlockRedstoneRepeater && newBlock instanceof BlockRedstoneRepeater) {
            return true;
        }
        if (originalBlock instanceof BlockRedstoneTorch && newBlock instanceof BlockRedstoneTorch) {
            return true;
        }
        return originalBlock instanceof BlockRedstoneLight && newBlock instanceof BlockRedstoneLight;
    }

    private TrackingUtil() {
    }

    public static User getNotifierOrOwnerFromBlock(Location<World> location) {
        BlockPos blockPos = ((IMixinLocation)((Object)location)).getBlockPos();
        return TrackingUtil.getNotifierOrOwnerFromBlock((WorldServer)location.getExtent(), blockPos);
    }

    public static User getNotifierOrOwnerFromBlock(WorldServer world, BlockPos blockPos) {
        IMixinChunk mixinChunk = (IMixinChunk)world.func_175726_f(blockPos);
        User notifier = mixinChunk.getBlockNotifier(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        User owner = mixinChunk.getBlockOwner(blockPos).orElse(null);
        return owner;
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhaseTracker.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(List<BlockSnapshot> snapshots, IPhaseState<?> state, PhaseContext<?> context) {
        if (snapshots.isEmpty()) {
            return false;
        }
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshots) {
            TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        context.getCapturedBlocksOrEmptyList().clear();
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            BlockPos pos;
            Location location;
            if (context.getNotifier().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, context.getNotifier().get());
            }
            if (context.getOwner().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.OWNER, context.getOwner().get());
            }
            try {
                state.associateAdditionalCauses(state, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
            ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(transactionArrays, blockEvents, mainEvents);
            if (postEvent == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Transaction> invalid = new ArrayList<Transaction>();
            boolean noCancelledTransactions = true;
            for (ChangeBlockEvent changeBlockEvent : blockEvents) {
                if (!changeBlockEvent.isCancelled()) continue;
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                    transaction.setValid(false);
                }
            }
            if (postEvent.isCancelled()) {
                noCancelledTransactions = false;
                for (Transaction transaction : postEvent.getTransactions()) {
                    transaction.setValid(false);
                }
            }
            for (Transaction transaction : postEvent.getTransactions()) {
                if (transaction.isValid()) continue;
                invalid.add(transaction);
                location = ((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null);
                if (location == null) continue;
                pos = ((IMixinLocation)((Object)location)).getBlockPos();
                context.getBlockItemDropSupplier().removeAllIfNotEmpty(pos);
                context.getBlockEntitySpawnSupplier().removeAllIfNotEmpty(pos);
                context.getBlockEntitySpawnSupplier().removeAllIfNotEmpty(pos);
            }
            if (!invalid.isEmpty()) {
                noCancelledTransactions = false;
                for (Transaction transaction : Lists.reverse(invalid)) {
                    ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlags.NONE);
                    if (!state.tracksBlockSpecificDrops() || (location = (Location)((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null)) == null) continue;
                    pos = ((IMixinLocation)((Object)location)).getBlockPos();
                    context.getBlockDropSupplier().removeAllIfNotEmpty(pos);
                }
            }
            boolean bl = TrackingUtil.performBlockAdditions(postEvent.getTransactions(), state, context, noCancelledTransactions);
            return bl;
        }
    }

    public static void iterateChangeBlockEvents(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        for (BlockChange blockChange : BlockChange.values()) {
            ChangeBlockEvent event;
            if (blockChange == BlockChange.DECAY || transactionArrays[blockChange.ordinal()].isEmpty()) continue;
            mainEvents[blockChange.ordinal()] = event = blockChange.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[blockChange.ordinal()]);
            if (event == null) continue;
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
        if (!transactionArrays[BlockChange.DECAY.ordinal()].isEmpty()) {
            ChangeBlockEvent event;
            mainEvents[BlockChange.DECAY.ordinal()] = event = BlockChange.DECAY.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[BlockChange.DECAY.ordinal()]);
            if (event != null) {
                SpongeImpl.postEvent(event);
                blockEvents.add(event);
            }
        }
    }

    public static boolean performBlockAdditions(List<Transaction<BlockSnapshot>> transactions, IPhaseState<?> phaseState, PhaseContext<?> phaseContext, boolean noCancelledTransactions) {
        SpongeProxyBlockAccess proxyBlockAccess = new SpongeProxyBlockAccess(transactions);
        CapturedMultiMapSupplier<BlockPos, ItemDropData> capturedBlockDrops = phaseContext.getBlockDropSupplier();
        CapturedMultiMapSupplier<BlockPos, EntityItem> capturedBlockItemEntityDrops = phaseContext.getBlockItemDropSupplier();
        CapturedMultiMapSupplier<BlockPos, net.minecraft.entity.Entity> capturedBlockEntitySpawns = phaseContext.getBlockEntitySpawnSupplier();
        for (Transaction<BlockSnapshot> transaction : transactions) {
            PhaseData peek;
            if (!transaction.isValid()) {
                noCancelledTransactions = false;
                continue;
            }
            if (transaction.getCustom().isPresent()) {
                transaction.getFinal().restore(true, BlockChangeFlags.NONE);
            }
            SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
            SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
            Location<World> worldLocation = oldBlockSnapshot.getLocation().get();
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)((Object)worldLocation.getExtent());
            BlockPos pos = ((IMixinLocation)((Object)oldBlockSnapshot.getLocation().get())).getBlockPos();
            capturedBlockDrops.acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemDataForBlockDrops(items, oldBlockSnapshot, phaseContext, phaseState));
            capturedBlockItemEntityDrops.acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemEntitiesForBlockDrops(items, oldBlockSnapshot, phaseContext, phaseState));
            capturedBlockEntitySpawns.acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnEntitiesForBlock(items, oldBlockSnapshot, phaseContext, phaseState));
            SpongeHooks.logBlockAction((net.minecraft.world.World)mixinWorldServer.asMinecraftWorld(), oldBlockSnapshot.blockChange, transaction);
            SpongeBlockChangeFlag changeFlag = oldBlockSnapshot.getChangeFlag();
            IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
            IBlockState newState = (IBlockState)newBlockSnapshot.getState();
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            if (changeFlag.performBlockPhysics() && originalState.func_177230_c() != newState.func_177230_c()) {
                newState.func_177230_c().func_176213_c((net.minecraft.world.World)mixinWorldServer.asMinecraftWorld(), pos, newState);
                peek = phaseTracker.getCurrentPhaseData();
                if (peek.state == GeneralPhase.Post.UNWINDING) {
                    peek.state.unwind(peek.context);
                }
            }
            proxyBlockAccess.proceed();
            phaseState.handleBlockChangeWithUser(oldBlockSnapshot.blockChange, transaction, phaseContext);
            if (changeFlag.isNotifyClients()) {
                mixinWorldServer.asMinecraftWorld().func_184138_a(pos, originalState, newState, changeFlag.getRawFlag());
            }
            if (changeFlag.updateNeighbors()) {
                mixinWorldServer.spongeNotifyNeighborsPostBlockChange(pos, originalState, newState, changeFlag);
            } else if (changeFlag.notifyObservers()) {
                mixinWorldServer.asMinecraftWorld().func_190522_c(pos, newState.func_177230_c());
            }
            peek = phaseTracker.getCurrentPhaseData();
            if (peek.state != GeneralPhase.Post.UNWINDING) continue;
            peek.state.unwind(peek.context);
        }
        return noCancelledTransactions;
    }

    public static void spawnItemEntitiesForBlockDrops(Collection<EntityItem> entityItems, SpongeBlockSnapshot newBlockSnapshot, PhaseContext<?> phaseContext, IPhaseState<?> phaseState) {
        List itemDrops = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(newBlockSnapshot);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            Optional<User> owner = phaseContext.getOwner();
            Optional<User> notifier = phaseContext.getNotifier();
            if (notifier.isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, notifier.get());
            }
            User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
            DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemDrops);
            SpongeImpl.postEvent(destruct);
            if (!destruct.isCancelled()) {
                for (Entity entity : destruct.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        }
    }

    public static void spawnItemDataForBlockDrops(Collection<ItemDropData> itemStacks, SpongeBlockSnapshot oldBlockSnapshot, PhaseContext<?> phaseContext, IPhaseState<?> state) {
        Vector3i position = oldBlockSnapshot.getPosition();
        List itemSnapshots = itemStacks.stream().map(ItemDropData::getStack).map(ItemStackUtil::snapshotOf).collect(Collectors.toList());
        ImmutableList originalSnapshots = ImmutableList.copyOf(itemSnapshots);
        Sponge.getCauseStackManager().pushCause(oldBlockSnapshot);
        DropItemEvent.Pre dropItemEventPre = SpongeEventFactory.createDropItemEventPre(Sponge.getCauseStackManager().getCurrentCause(), (List)originalSnapshots, itemSnapshots);
        Sponge.getCauseStackManager().popCause();
        SpongeImpl.postEvent(dropItemEventPre);
        if (dropItemEventPre.isCancelled()) {
            return;
        }
        World world = oldBlockSnapshot.getLocation().get().getExtent();
        WorldServer worldServer = (WorldServer)world;
        List itemDrops = itemStacks.stream().map(itemStack -> {
            ItemStack minecraftStack = itemStack.getStack();
            float f = 0.5f;
            double offsetX = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetY = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetZ = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double x = (double)position.getX() + offsetX;
            double y = (double)position.getY() + offsetY;
            double z = (double)position.getZ() + offsetZ;
            EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x, y, z, minecraftStack);
            entityitem.func_174869_p();
            return entityitem;
        }).map(EntityUtil::fromNative).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(oldBlockSnapshot);
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
            if (phaseContext.getNotifier().isPresent()) {
                Sponge.getCauseStackManager().addContext(EventContextKeys.NOTIFIER, phaseContext.getNotifier().get());
            }
            User entityCreator = phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null));
            DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemDrops);
            SpongeImpl.postEvent(destruct);
            if (!destruct.isCancelled()) {
                for (Entity entity : destruct.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        }
    }

    public static void spawnEntitiesForBlock(Collection<net.minecraft.entity.Entity> entities, SpongeBlockSnapshot newBlockSnapshot, PhaseContext<?> phaseContext, IPhaseState<?> phaseState) {
        List entitiesSpawned = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        Optional<User> owner = phaseContext.getOwner();
        Optional<User> notifier = phaseContext.getNotifier();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        SpawnEntityEvent destruct = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entitiesSpawned);
        SpongeImpl.postEvent(destruct);
        if (!destruct.isCancelled()) {
            for (Entity entity : destruct.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        }
    }

    public static ChangeBlockEvent.Post throwMultiEventsAndCreatePost(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        if (!blockEvents.isEmpty()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                for (BlockChange blockChange : BlockChange.values()) {
                    ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                    if (mainEvent == null) continue;
                    Sponge.getCauseStackManager().pushCause(mainEvent);
                }
                ImmutableList<Transaction<BlockSnapshot>> transactions = transactionArrays[4];
                ChangeBlockEvent.Post post = SpongeEventFactory.createChangeBlockEventPost(Sponge.getCauseStackManager().getCurrentCause(), transactions);
                SpongeImpl.postEvent(post);
                ChangeBlockEvent.Post post2 = post;
                return post2;
            }
        }
        return null;
    }

    public static void splitAndSpawnEntities(List<Entity> entities) {
        TrackingUtil.splitAndSpawnEntities(entities, entity -> {});
    }

    public static void splitAndSpawnEntities(List<Entity> entities, Consumer<IMixinEntity> mixinEntityConsumer) {
        if (entities.size() > 1) {
            HashMultimap entityListMap = HashMultimap.create();
            for (Entity entity : entities) {
                entityListMap.put((Object)entity.getWorld(), (Object)entity);
            }
            for (Map.Entry entry : entityListMap.asMap().entrySet()) {
                World world = (World)entry.getKey();
                ArrayList worldEntities = new ArrayList((Collection)entry.getValue());
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), worldEntities);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) continue;
                for (Entity entity : event.getEntities()) {
                    mixinEntityConsumer.accept(EntityUtil.toMixin(entity));
                    ((IMixinWorldServer)((Object)world)).forceSpawnEntity(entity);
                }
            }
            return;
        }
        Entity singleEntity = entities.get(0);
        World world = singleEntity.getWorld();
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (Entity entity : spawnEntityEvent.getEntities()) {
                mixinEntityConsumer.accept(EntityUtil.toMixin(entity));
                ((IMixinWorldServer)((Object)world)).forceSpawnEntity(entity);
            }
        }
    }
}

