/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import co.aikar.timings.SpongeTimingsFactory;
import co.aikar.timings.Timing;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.util.ServerUtils;

public final class DataProcessorDelegate<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
implements DataProcessor<M, I> {
    private final ImmutableList<Tuple<DataProcessor<M, I>, Timing>> processors;

    public DataProcessorDelegate(ImmutableList<DataProcessor<M, I>> processors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataProcessor processor : processors) {
            builder.add(new Tuple<DataProcessor, Timing>(processor, SpongeTimingsFactory.ofSafe(SpongeImpl.getPlugin(), processor.getClass().getCanonicalName())));
        }
        this.processors = builder.build();
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(DataHolder dataHolder) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder)) {
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                return true;
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return false;
    }

    @Override
    public boolean supports(EntityType entityType) {
        return false;
    }

    @Override
    public Optional<M> from(DataHolder dataHolder) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder)) {
                Optional optional = ((DataProcessor)tuple.getFirst()).from(dataHolder);
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                if (optional.isPresent()) {
                    return optional;
                }
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return Optional.empty();
    }

    @Override
    public Optional<M> fill(DataHolder dataHolder, M manipulator, MergeFunction overlap) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder)) {
                Optional<M> optional = ((DataProcessor)tuple.getFirst()).fill(dataHolder, manipulator, overlap);
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                if (optional.isPresent()) {
                    return optional;
                }
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return Optional.empty();
    }

    @Override
    public Optional<M> fill(DataContainer container, M m) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            Optional<M> optional = ((DataProcessor)tuple.getFirst()).fill(container, m);
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).stopTiming();
            }
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult set(DataHolder dataHolder, M manipulator, MergeFunction function) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            DataTransactionResult result;
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder) && !(result = ((DataProcessor)tuple.getFirst()).set(dataHolder, manipulator, function)).getType().equals((Object)DataTransactionResult.Type.FAILURE)) {
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                return result;
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return DataTransactionResult.failResult(manipulator.asImmutable().getValues());
    }

    @Override
    public Optional<I> with(Key<? extends BaseValue<?>> key, Object value, I immutable) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            Optional<I> optional = ((DataProcessor)tuple.getFirst()).with(key, value, immutable);
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).stopTiming();
            }
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder)) {
                DataTransactionResult result = ((DataProcessor)tuple.getFirst()).remove(dataHolder);
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                if (!result.getType().equals((Object)DataTransactionResult.Type.FAILURE)) {
                    return result;
                }
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public Optional<M> createFrom(DataHolder dataHolder) {
        boolean callingFromMinecraftThread = ServerUtils.isCallingFromMainThread();
        for (Tuple tuple : this.processors) {
            if (callingFromMinecraftThread) {
                ((Timing)tuple.getSecond()).startTiming();
            }
            if (((DataProcessor)tuple.getFirst()).supports(dataHolder)) {
                Optional optional = ((DataProcessor)tuple.getFirst()).createFrom(dataHolder);
                if (callingFromMinecraftThread) {
                    ((Timing)tuple.getSecond()).stopTiming();
                }
                if (optional.isPresent()) {
                    return optional;
                }
            }
            if (!callingFromMinecraftThread) continue;
            ((Timing)tuple.getSecond()).stopTiming();
        }
        return Optional.empty();
    }
}

