/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHorseData;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHorseData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;
import org.spongepowered.common.registry.type.entity.HorseColorRegistryModule;
import org.spongepowered.common.registry.type.entity.HorseStyleRegistryModule;

public class HorseDataProcessor
extends AbstractEntityDataProcessor<EntityHorse, HorseData, ImmutableHorseData> {
    public HorseDataProcessor() {
        super(EntityHorse.class);
    }

    @Override
    protected HorseData createManipulator() {
        return new SpongeHorseData();
    }

    @Override
    protected boolean doesDataExist(EntityHorse entity) {
        return true;
    }

    @Override
    protected boolean set(EntityHorse entity, Map<Key<?>, Object> keyValues) {
        SpongeHorseColor horseColor = (SpongeHorseColor)keyValues.get(Keys.HORSE_COLOR);
        SpongeHorseStyle horseStyle = (SpongeHorseStyle)keyValues.get(Keys.HORSE_STYLE);
        int variant = EntityUtil.getHorseInternalVariant(horseColor, horseStyle);
        entity.func_110235_q(variant);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityHorse entity) {
        return ImmutableMap.of(Keys.HORSE_COLOR, (Object)HorseColorRegistryModule.getHorseColor(entity), Keys.HORSE_STYLE, (Object)HorseStyleRegistryModule.getHorseStyle(entity));
    }

    @Override
    public Optional<HorseData> fill(DataContainer container, HorseData horseData) {
        horseData.set(Keys.HORSE_COLOR, HorseColorRegistryModule.getHorseColor(container));
        horseData.set(Keys.HORSE_STYLE, HorseStyleRegistryModule.getHorseStyle(container));
        return Optional.of(horseData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

