/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableWireAttachmentData;
import org.spongepowered.api.data.manipulator.mutable.block.WireAttachmentData;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.type.WireAttachmentTypes;
import org.spongepowered.api.data.value.immutable.ImmutableMapValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeWireAttachementData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeWireAttachmentData
extends AbstractImmutableData<ImmutableWireAttachmentData, WireAttachmentData>
implements ImmutableWireAttachmentData {
    private final ImmutableMap<Direction, WireAttachmentType> wireAttachmentMap;
    private final ImmutableMapValue<Direction, WireAttachmentType> wireAttachmentsValue;
    private final ImmutableValue<WireAttachmentType> northValue;
    private final ImmutableValue<WireAttachmentType> southValue;
    private final ImmutableValue<WireAttachmentType> eastValue;
    private final ImmutableValue<WireAttachmentType> westValue;

    public ImmutableSpongeWireAttachmentData(Map<Direction, WireAttachmentType> wireAttachmentMap) {
        super(ImmutableWireAttachmentData.class);
        this.wireAttachmentMap = ImmutableMap.copyOf(wireAttachmentMap);
        this.wireAttachmentsValue = new ImmutableSpongeMapValue<Direction, WireAttachmentType>(Keys.WIRE_ATTACHMENTS, wireAttachmentMap);
        this.northValue = ImmutableSpongeValue.cachedOf(Keys.WIRE_ATTACHMENT_NORTH, WireAttachmentTypes.NONE, wireAttachmentMap.get((Object)Direction.NORTH));
        this.southValue = ImmutableSpongeValue.cachedOf(Keys.WIRE_ATTACHMENT_SOUTH, WireAttachmentTypes.NONE, wireAttachmentMap.get((Object)Direction.SOUTH));
        this.eastValue = ImmutableSpongeValue.cachedOf(Keys.WIRE_ATTACHMENT_EAST, WireAttachmentTypes.NONE, wireAttachmentMap.get((Object)Direction.EAST));
        this.westValue = ImmutableSpongeValue.cachedOf(Keys.WIRE_ATTACHMENT_WEST, WireAttachmentTypes.NONE, wireAttachmentMap.get((Object)Direction.WEST));
    }

    @Override
    public ImmutableMapValue<Direction, WireAttachmentType> wireAttachments() {
        return this.wireAttachmentsValue;
    }

    @Override
    public ImmutableValue<WireAttachmentType> wireAttachmentNorth() {
        return this.northValue;
    }

    @Override
    public ImmutableValue<WireAttachmentType> wireAttachmentSouth() {
        return this.southValue;
    }

    @Override
    public ImmutableValue<WireAttachmentType> wireAttachmentEast() {
        return this.eastValue;
    }

    @Override
    public ImmutableValue<WireAttachmentType> wireAttachmentWest() {
        return this.westValue;
    }

    @Override
    public WireAttachmentData asMutable() {
        return new SpongeWireAttachementData((Map<Direction, WireAttachmentType>)this.wireAttachmentMap);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.WIRE_ATTACHMENTS.getQuery(), this.wireAttachmentMap.entrySet().stream().collect(Collectors.toMap(k -> ((Direction)((Object)((Object)k.getKey()))).name(), v -> ((WireAttachmentType)v.getValue()).getId()))).set(Keys.WIRE_ATTACHMENT_NORTH.getQuery(), (Object)((WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.NORTH)).getId()).set(Keys.WIRE_ATTACHMENT_EAST.getQuery(), (Object)((WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.EAST)).getId()).set(Keys.WIRE_ATTACHMENT_SOUTH.getQuery(), (Object)((WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.SOUTH)).getId()).set(Keys.WIRE_ATTACHMENT_WEST.getQuery(), (Object)((WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.WEST)).getId());
    }

    public ImmutableMap<Direction, WireAttachmentType> getWireAttachmentMap() {
        return this.wireAttachmentMap;
    }

    private WireAttachmentType getNorth() {
        return (WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.NORTH);
    }

    private WireAttachmentType getSouth() {
        return (WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.SOUTH);
    }

    private WireAttachmentType getEast() {
        return (WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.EAST);
    }

    private WireAttachmentType getWest() {
        return (WireAttachmentType)this.wireAttachmentMap.get((Object)Direction.WEST);
    }

    @Override
    protected void registerGetters() {
        this.registerKeyValue(Keys.WIRE_ATTACHMENTS, this::wireAttachments);
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_NORTH, this::wireAttachmentNorth);
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_SOUTH, this::wireAttachmentSouth);
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_EAST, this::wireAttachmentEast);
        this.registerKeyValue(Keys.WIRE_ATTACHMENT_WEST, this::wireAttachmentWest);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENTS, this::getWireAttachmentMap);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_NORTH, this::getNorth);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_SOUTH, this::getSouth);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_EAST, this::getEast);
        this.registerFieldGetter(Keys.WIRE_ATTACHMENT_WEST, this::getWest);
    }
}

