/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.state;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.util.DataQueries;

public class SpongeBlockStateMetaContentUpdater
implements DataContentUpdater {
    @Override
    public int getInputVersion() {
        return 1;
    }

    @Override
    public int getOutputVersion() {
        return 2;
    }

    @Override
    public DataView update(DataView content) {
        String blockTypeId = content.getString(DataQueries.BLOCK_TYPE).get();
        Optional<BlockType> blockType = Sponge.getRegistry().getType(BlockType.class, blockTypeId);
        if (!blockType.isPresent()) {
            throw new InvalidDataException("Could not find a block type for the given id: " + blockTypeId);
        }
        int meta = content.getInt(DataQueries.BLOCK_STATE_UNSAFE_META).orElse(0);
        BlockType type = blockType.get();
        IBlockState blockState = ((Block)type).func_176203_a(meta);
        content.remove(DataQueries.BLOCK_TYPE);
        content.remove(DataQueries.BLOCK_STATE_UNSAFE_META);
        BlockState apiState = (BlockState)blockState;
        content.set(DataQueries.BLOCK_STATE, apiState.getId());
        content.set(Queries.CONTENT_VERSION, (Object)2);
        return content;
    }
}

