/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.CustomDataConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.util.IpSet;

public class SpongeConfig<T extends ConfigBase> {
    private static final String HEADER = "1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n";
    private Type type;
    private HoconConfigurationLoader loader;
    private CommentedConfigurationNode root = SimpleCommentedConfigurationNode.root(ConfigurationOptions.defaults().setHeader("1.0\n\n# If you need help with the configuration or have any questions related to Sponge,\n# join us at the IRC or drop by our forums and leave a post.\n\n# IRC: #sponge @ irc.esper.net ( https://webchat.esper.net/?channel=sponge )\n# Forums: https://forums.spongepowered.org/\n"));
    private ObjectMapper.BoundInstance configMapper;
    private T configBase;
    private String modId;

    public SpongeConfig(Type type, Path path, String modId) {
        this.type = type;
        this.modId = modId;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
            this.configMapper = ObjectMapper.forClass(this.type.type).bindToNew();
            this.reload();
            this.save();
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to initialize configuration", (Throwable)e);
        }
    }

    public T getConfig() {
        return this.configBase;
    }

    public void save() {
        try {
            this.configMapper.serialize(this.root.getNode(this.modId));
            this.loader.save(this.root);
        }
        catch (IOException | ObjectMappingException e) {
            SpongeImpl.getLogger().error("Failed to save configuration", (Throwable)e);
        }
    }

    public void reload() {
        try {
            this.root = (CommentedConfigurationNode)this.loader.load(ConfigurationOptions.defaults().setSerializers(TypeSerializers.getDefaultSerializers().newChild().registerType(TypeToken.of(IpSet.class), new IpSet.IpSetSerializer())).setHeader(HEADER));
            this.configBase = (ConfigBase)this.configMapper.populate(this.root.getNode(this.modId));
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Failed to load configuration", (Throwable)e);
        }
    }

    public CompletableFuture<CommentedConfigurationNode> updateSetting(String key, Object value) {
        return Functional.asyncFailableFuture(() -> {
            CommentedConfigurationNode upd = this.getSetting(key);
            upd.setValue(value);
            this.configBase = (ConfigBase)this.configMapper.populate(this.root.getNode(this.modId));
            this.loader.save(this.root);
            return upd;
        }, ForkJoinPool.commonPool());
    }

    public CommentedConfigurationNode getRootNode() {
        return this.root.getNode(this.modId);
    }

    public CommentedConfigurationNode getSetting(String key) {
        if (key.equalsIgnoreCase("config-enabled")) {
            return this.getRootNode().getNode(key);
        }
        if (!key.contains(".") || key.indexOf(46) == key.length() - 1) {
            return null;
        }
        String category = key.substring(0, key.indexOf(46));
        String prop = key.substring(key.indexOf(46) + 1);
        return this.getRootNode().getNode(category).getNode(prop);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        CUSTOM_DATA(CustomDataConfig.class),
        GLOBAL(GlobalConfig.class),
        DIMENSION(DimensionConfig.class),
        WORLD(WorldConfig.class);

        final Class<? extends ConfigBase> type;

        private Type(Class<? extends ConfigBase> type) {
            this.type = type;
        }
    }
}

