/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.item.inventory.property.IntProperty;
import org.spongepowered.api.util.Coerce;

public class MappedIntProperty
extends AbstractInventoryProperty<Integer, Integer> {
    public MappedIntProperty(Integer key, Integer value) {
        super(key, value);
    }

    public MappedIntProperty(Integer key, Integer value, Property.Operator operator) {
        super(key, value, operator);
    }

    public MappedIntProperty(Object key, Object value, Property.Operator operator) {
        super(Coerce.toInteger(key), Coerce.toInteger(value), operator);
    }

    void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        if (other instanceof IntProperty || other instanceof MappedIntProperty && other.getKey().equals(this.getKey())) {
            return ((Integer)this.getValue()).compareTo(Coerce.toInteger(other.getValue()));
        }
        return 1;
    }

    public static MappedIntProperty of(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.EQUAL);
    }

    public static MappedIntProperty not(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.NOTEQUAL);
    }

    public static MappedIntProperty greaterThan(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.GREATER);
    }

    public static MappedIntProperty greaterThanOrEqual(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.GEQUAL);
    }

    public static MappedIntProperty lessThan(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.LESS);
    }

    public static MappedIntProperty lessThanOrEqual(Object key, Object value) {
        return new MappedIntProperty(key, value, Property.Operator.LEQUAL);
    }
}

