/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.server;

import java.util.Hashtable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.mod.service.world.SpongeChunkTicketManager;

@Mixin(value={MinecraftServer.class}, priority=1001)
public abstract class MixinMinecraftServer
implements Server,
IMixinMinecraftServer {
    public ChunkTicketManager chunkTicketManager = new SpongeChunkTicketManager();
    @Shadow(remap=false)
    public Hashtable<Integer, long[]> worldTickTimes;

    @Override
    public long[] getWorldTickTimes(int dimensionId) {
        return this.worldTickTimes.get(dimensionId);
    }

    @Override
    public void putWorldTickTimes(int dimensionId, long[] tickTimes) {
        this.worldTickTimes.put(dimensionId, tickTimes);
    }

    @Override
    public void removeWorldTickTimes(int dimensionId) {
        this.worldTickTimes.remove(dimensionId);
    }

    @Override
    public ChunkTicketManager getChunkTicketManager() {
        return this.chunkTicketManager;
    }

    @Overwrite
    public WorldServer func_71218_a(int dimensionId) {
        WorldServer ret = WorldManager.getWorldByDimensionId(dimensionId).orElse(null);
        if (ret == null) {
            DimensionManager.initDimension((int)dimensionId);
            ret = WorldManager.getWorldByDimensionId(dimensionId).orElse(null);
        }
        if (ret == null) {
            return WorldManager.getWorldByDimensionId(0).orElseThrow(() -> new RuntimeException("Attempt made to initialize dimension before overworld is loaded!"));
        }
        return ret;
    }
}

