/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common.registry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.registry.SpongeVillagerRegistry;
import org.spongepowered.mod.interfaces.IMixinVillagerCareer;
import org.spongepowered.mod.registry.SpongeForgeVillagerRegistry;

@Mixin(value={VillagerRegistry.VillagerCareer.class}, remap=false)
public class MixinVillagerCareer
implements IMixinVillagerCareer {
    @Shadow
    private int id;
    @Shadow
    private VillagerRegistry.VillagerProfession profession;
    @Shadow
    private List<List<EntityVillager.ITradeList>> trades;
    @Shadow
    private String name;
    private boolean delayed;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        this.delayed = !SpongeForgeVillagerRegistry.fromNative((VillagerRegistry.VillagerCareer)this).isPresent();
    }

    @Override
    public VillagerRegistry.VillagerProfession getProfession() {
        return this.profession;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isDelayed() {
        return this.delayed;
    }

    @Override
    public void performDelayedInit() {
        this.registerTrades();
    }

    @Overwrite
    public VillagerRegistry.VillagerCareer addTrade(int level, EntityVillager.ITradeList ... trades) {
        ArrayList levelTrades;
        if (level <= 0) {
            throw new IllegalArgumentException("Levels start at 1");
        }
        Optional<SpongeCareer> spongeCareer = SpongeForgeVillagerRegistry.fromNative((VillagerRegistry.VillagerCareer)this);
        if (!spongeCareer.isPresent()) {
            SpongeImpl.getLogger().debug("Delaying trade registration for career {}", (Object)this.name);
        } else {
            for (EntityVillager.ITradeList trade : trades) {
                SpongeVillagerRegistry.getInstance().addMutator(spongeCareer.get(), level, (TradeOfferListMutator)trade);
            }
        }
        ArrayList arrayList = levelTrades = level <= this.trades.size() ? this.trades.get(level - 1) : null;
        if (levelTrades == null) {
            while (this.trades.size() < level) {
                levelTrades = Lists.newArrayList();
                this.trades.add(levelTrades);
            }
        }
        if (levelTrades == null) {
            levelTrades = Lists.newArrayList();
            this.trades.set(level - 1, levelTrades);
        }
        for (EntityVillager.ITradeList t : trades) {
            levelTrades.add(t);
        }
        return (VillagerRegistry.VillagerCareer)this;
    }

    private void registerTrades() {
        Career career = SpongeForgeVillagerRegistry.fromNative((VillagerRegistry.VillagerCareer)this).get();
        for (int i = 0; i < this.trades.size(); ++i) {
            int level = i + 1;
            List<EntityVillager.ITradeList> trades = this.trades.get(i);
            for (EntityVillager.ITradeList trade : trades) {
                SpongeVillagerRegistry.getInstance().addMutator(career, level, (TradeOfferListMutator)trade);
            }
        }
    }
}

