/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.item.inventory.fabric;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.lens.Fabric;

public class IItemHandlerFabric
implements Fabric<IItemHandler> {
    private final IItemHandler inventory;

    public IItemHandlerFabric(IItemHandler inventory) {
        this.inventory = inventory;
    }

    @Override
    public Collection<IItemHandler> allInventories() {
        return ImmutableSet.of((Object)this.inventory);
    }

    @Override
    public IItemHandler get(int index) {
        return this.inventory;
    }

    @Override
    public ItemStack getStack(int index) {
        return this.inventory.getStackInSlot(index);
    }

    @Override
    public void setStack(int index, ItemStack stack) {
        IItemHandlerFabric.setIItemHandlerStack(this.inventory, index, stack);
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.getSlotLimit(0);
    }

    @Override
    public Translation getDisplayName() {
        return new FixedTranslation(this.getClass().getName());
    }

    @Override
    public int getSize() {
        return this.inventory.getSlots();
    }

    @Override
    public void clear() {
    }

    @Override
    public void markDirty() {
    }

    protected static void setIItemHandlerStack(IItemHandler handler, int index, ItemStack stack) {
        ItemStack prev = handler.getStackInSlot(index);
        if (prev != null) {
            ItemStack extracted;
            for (int cnt = prev.func_190916_E(); cnt > 0; cnt -= extracted.func_190916_E()) {
                extracted = handler.extractItem(index, cnt, false);
                if (extracted.func_190916_E() != 0) continue;
                break;
            }
        }
        prev = stack;
        while (!stack.func_190926_b() && prev != (stack = handler.insertItem(index, stack, false)) && prev.func_190916_E() != stack.func_190916_E()) {
            prev = stack;
        }
    }
}

