/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.fml.common.LoaderState;
import org.spongepowered.api.GameState;

public class StateRegistry {
    private static Map<LoaderState, GameState> stateMap = Maps.newHashMap();

    private static void register(LoaderState state, GameState gameState) {
        stateMap.put(state, gameState);
    }

    public static GameState getState(LoaderState state) {
        return stateMap.get(state);
    }

    static {
        StateRegistry.register(LoaderState.CONSTRUCTING, GameState.CONSTRUCTION);
        StateRegistry.register(LoaderState.PREINITIALIZATION, GameState.PRE_INITIALIZATION);
        StateRegistry.register(LoaderState.INITIALIZATION, GameState.INITIALIZATION);
        StateRegistry.register(LoaderState.POSTINITIALIZATION, GameState.POST_INITIALIZATION);
        StateRegistry.register(LoaderState.AVAILABLE, GameState.LOAD_COMPLETE);
        StateRegistry.register(LoaderState.SERVER_ABOUT_TO_START, GameState.SERVER_ABOUT_TO_START);
        StateRegistry.register(LoaderState.SERVER_STARTING, GameState.SERVER_STARTING);
        StateRegistry.register(LoaderState.SERVER_STARTED, GameState.SERVER_STARTED);
        StateRegistry.register(LoaderState.SERVER_STOPPING, GameState.SERVER_STOPPING);
        StateRegistry.register(LoaderState.SERVER_STOPPED, GameState.SERVER_STOPPED);
        StateRegistry.register(LoaderState.NOINIT, GameState.CONSTRUCTION);
        StateRegistry.register(LoaderState.LOADING, GameState.CONSTRUCTION);
        StateRegistry.register(LoaderState.ERRORED, GameState.SERVER_STOPPED);
    }
}

