/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IEnvironmentTokenProvider;
import org.spongepowered.common.launch.SpongeLaunch;
import org.spongepowered.launch.JavaVersionCheckUtils;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class SpongeCoremod
implements IFMLLoadingPlugin {
    static File modFile;

    public SpongeCoremod() {
        Launch.classLoader.addTransformerExclusion("org.spongepowered.launch.JavaVersionCheckUtils");
        try {
            JavaVersionCheckUtils.ensureJava8();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearSecurityManager();
            Runtime.getRuntime().exit(1);
        }
        SpongeLaunch.addJreExtensionsToClassPath();
        Launch.classLoader.addClassLoaderExclusion("org.spongepowered.common.launch.");
        Launch.classLoader.addClassLoaderExclusion("org.slf4j.");
        SpongeLaunch.initPaths((File)FMLInjectionData.data()[6]);
        SpongeLaunch.setupMixinEnvironment();
        if (this.isProductionEnvironment()) {
            Mixins.registerErrorHandlerClass("org.spongepowered.mod.mixin.handler.MixinErrorHandler");
        }
        Mixins.addConfiguration("mixins.forge.core.json");
        Mixins.addConfiguration("mixins.forge.bungeecord.json");
        Mixins.addConfiguration("mixins.forge.entityactivation.json");
        MixinEnvironment.getDefaultEnvironment().registerTokenProviderClass("org.spongepowered.mod.SpongeCoremod$TokenProvider");
        Mixins.addConfiguration("mixins.forge.preinit.json");
        MixinEnvironment.getEnvironment(MixinEnvironment.Phase.PREINIT).registerTokenProviderClass("org.spongepowered.mod.SpongeCoremod$TokenProvider");
        Mixins.addConfiguration("mixins.forge.init.json");
        MixinEnvironment.getEnvironment(MixinEnvironment.Phase.INIT).registerTokenProviderClass("org.spongepowered.mod.SpongeCoremod$TokenProvider");
        Launch.classLoader.addClassLoaderExclusion("org.spongepowered.api.event.Cancellable");
        Launch.classLoader.addClassLoaderExclusion("org.spongepowered.api.eventgencore.annotation.PropertySettings");
        Launch.classLoader.addClassLoaderExclusion("org.spongepowered.api.util.ResettableBuilder");
        Launch.classLoader.addTransformerExclusion("ninja.leaping.configurate.");
        Launch.classLoader.addTransformerExclusion("org.apache.commons.lang3.");
        Launch.classLoader.addTransformerExclusion("org.spongepowered.mod.interfaces.IMixinEvent");
        SpongeLaunch.setupSuperClassTransformer();
    }

    private boolean isProductionEnvironment() {
        return System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir") == null;
    }

    private void clearSecurityManager() {
        try {
            Field field = System.class.getDeclaredField("security");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{"org.spongepowered.common.launch.transformer.SpongeSuperclassTransformer"};
    }

    public String getModContainerClass() {
        return "org.spongepowered.mod.SpongeMod";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        FMLInjectionData.containers.add("org.spongepowered.mod.SpongeApiModContainer");
        modFile = (File)data.get("coremodLocation");
        if (modFile == null) {
            modFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        }
    }

    public String getAccessTransformerClass() {
        return "org.spongepowered.mod.asm.transformer.SpongeAccessTransformer";
    }

    public static final class TokenProvider
    implements IEnvironmentTokenProvider {
        @Override
        public int getPriority() {
            return 1000;
        }

        @Override
        public Integer getToken(String token, MixinEnvironment env) {
            if ("FORGE".equals(token)) {
                return ForgeVersion.getBuildVersion();
            }
            if ("FML".equals(token)) {
                String fmlVersion = Loader.instance().getFMLVersionString();
                int build = Integer.parseInt(fmlVersion.substring(fmlVersion.lastIndexOf(46) + 1));
                return build;
            }
            return null;
        }
    }
}

