/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.item.Item;
import net.minecraft.util.CooldownTracker;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CooldownTracker.class})
public abstract class MixinCooldownTracker
implements org.spongepowered.api.entity.living.player.CooldownTracker {
    @Shadow
    @Final
    private Map<Item, CooldownTracker.Cooldown> field_185147_a;
    @Shadow
    private int field_185148_b;
    private boolean lastSetCooldownResult;

    @Shadow
    public abstract boolean func_185141_a(Item var1);

    @Shadow
    public abstract float func_185143_a(Item var1, float var2);

    @Shadow
    public abstract void func_185145_a(Item var1, int var2);

    @Override
    public boolean hasCooldown(ItemType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        return this.func_185141_a((Item)type);
    }

    @Override
    public OptionalInt getCooldown(ItemType type) {
        int remainingCooldown;
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        this.isItem(type);
        CooldownTracker.Cooldown cooldown = this.field_185147_a.get((Item)type);
        if (cooldown != null && (remainingCooldown = cooldown.field_185138_b - this.field_185148_b) > 0) {
            return OptionalInt.of(remainingCooldown);
        }
        return OptionalInt.empty();
    }

    @Override
    public boolean setCooldown(ItemType type, int ticks) {
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        this.isItem(type);
        this.func_185145_a((Item)type, ticks);
        return this.lastSetCooldownResult;
    }

    @Inject(method={"setCooldown"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void catchIt(Item item, int ticks, CallbackInfo ci) {
        this.lastSetCooldownResult = this.throwSetCooldownEvent((ItemType)item, ticks);
        if (!this.lastSetCooldownResult) {
            ci.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/Map$Entry;getKey()Ljava/lang/Object;"))
    private Object onTick(Map.Entry<Item, CooldownTracker.Cooldown> entry) {
        this.throwEndCooldownEvent((ItemType)entry.getKey());
        return entry.getKey();
    }

    @Override
    public boolean resetCooldown(ItemType type) {
        return this.setCooldown(type, 0);
    }

    @Override
    public OptionalDouble getFractionRemaining(ItemType type) {
        Preconditions.checkNotNull((Object)type, (Object)"Item type cannot be null!");
        this.isItem(type);
        float cooldown = this.func_185143_a((Item)type, 0.0f);
        if (cooldown > 0.0f) {
            return OptionalDouble.of(cooldown);
        }
        return OptionalDouble.empty();
    }

    private void isItem(ItemType type) {
        if (!(type instanceof Item)) {
            throw new RuntimeException("The specified ItemType was not properly mapped internally.");
        }
    }

    protected boolean throwSetCooldownEvent(ItemType type, int ticks) {
        return true;
    }

    protected void throwEndCooldownEvent(ItemType type) {
    }
}

