/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.interfaces.inventory.trait.IInventoryObservable;
import org.spongepowered.common.item.inventory.observer.InventoryEventArgs;
import org.spongepowered.common.util.observer.Observable;
import org.spongepowered.common.util.observer.Observer;

@Mixin(value={Slot.class, ItemStack.class})
public abstract class TraitInventoryObservable
implements IInventoryObservable {
    private final List<Observer<InventoryEventArgs>> observers = new ArrayList<Observer<InventoryEventArgs>>();

    @Override
    public Observable<InventoryEventArgs> addObserver(Observer<InventoryEventArgs> observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
        return this;
    }

    @Override
    public Observable<InventoryEventArgs> removeObserver(Observer<InventoryEventArgs> observer) {
        this.observers.remove(observer);
        return this;
    }

    @Override
    public Observable<InventoryEventArgs> clearObservers() {
        this.observers.clear();
        return this;
    }

    @Override
    public Observable<InventoryEventArgs> raise(InventoryEventArgs eventArgs) {
        for (Observer<InventoryEventArgs> observer : this.observers) {
            observer.notify(this, eventArgs);
        }
        return this;
    }

    @Override
    public Iterable<Observer<InventoryEventArgs>> getObservers() {
        return this.observers;
    }
}

