/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.advancement.ICriterion;
import org.spongepowered.common.advancement.SpongeAdvancementBuilder;
import org.spongepowered.common.advancement.SpongeAdvancementTree;
import org.spongepowered.common.advancement.SpongeScoreCriterion;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancement;
import org.spongepowered.common.interfaces.advancement.IMixinCriterion;
import org.spongepowered.common.interfaces.advancement.IMixinDisplayInfo;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;
import org.spongepowered.common.registry.type.advancement.AdvancementTreeRegistryModule;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={net.minecraft.advancements.Advancement.class})
public class MixinAdvancement
implements Advancement,
IMixinAdvancement {
    @Shadow
    @Final
    @Mutable
    @Nullable
    private net.minecraft.advancements.Advancement field_192076_a;
    @Shadow
    @Final
    private ResourceLocation field_192079_d;
    @Shadow
    @Final
    @Mutable
    private String[][] field_192081_f;
    @Shadow
    @Final
    @Mutable
    private Map<String, Criterion> field_192080_e;
    @Shadow
    @Final
    @Nullable
    private DisplayInfo field_192077_b;
    @Shadow
    @Final
    private Set<net.minecraft.advancements.Advancement> field_192082_g;
    @Shadow
    @Final
    private ITextComponent field_193125_h;
    private AdvancementCriterion criterion;
    @Nullable
    private AdvancementTree tree;
    private List<Text> toastText;
    private Text text;
    private String spongeId;
    private String name;
    @Nullable
    private net.minecraft.advancements.Advancement tempParent;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(ResourceLocation id, @Nullable net.minecraft.advancements.Advancement parentIn, @Nullable DisplayInfo displayIn, AdvancementRewards rewardsIn, Map<String, Criterion> criteriaIn, String[][] requirementsIn, CallbackInfo ci) {
        if (displayIn != null) {
            ((IMixinDisplayInfo)displayIn).setAdvancement(this);
        }
        String path = id.func_110623_a();
        this.name = path.replace('/', '_');
        this.spongeId = id.func_110624_b() + ':' + this.name;
        if (displayIn != null) {
            this.name = SpongeTexts.toPlain(displayIn.func_192297_a());
        }
        if (!AdvancementRegistryModule.INSIDE_REGISTER_EVENT) {
            AdvancementRegistryModule.getInstance().registerAdditionalCatalog(this);
        } else {
            this.tempParent = parentIn;
            this.field_192076_a = SpongeAdvancementBuilder.DUMMY_ROOT_ADVANCEMENT;
        }
        if (parentIn == null) {
            if (path.endsWith("/root")) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            String name = path = path.replace('/', '_');
            if (displayIn != null) {
                name = this.name;
            }
            path = id.func_110624_b() + ':' + path;
            this.tree = new SpongeAdvancementTree(this, path, name);
            AdvancementTreeRegistryModule.getInstance().registerAdditionalCatalog(this.tree);
        } else {
            this.tree = ((Advancement)parentIn).getTree().orElse(null);
        }
        this.text = SpongeTexts.toText(this.field_193125_h);
        ImmutableList.Builder toastText = ImmutableList.builder();
        if (this.field_192077_b != null) {
            FrameType frameType = this.field_192077_b.func_192291_d();
            toastText.add((Object)Text.builder(new SpongeTranslation("advancements.toast." + frameType.func_192307_a()), new Object[0]).format(((AdvancementType)frameType).getTextFormat()).build());
            toastText.add((Object)this.getDisplayInfo().get().getTitle());
        } else {
            toastText.add((Object)Text.of("Unlocked advancement"));
            toastText.add((Object)Text.of(this.getId()));
        }
        this.toastText = toastText.build();
        HashSet<String> scoreCriteria = new HashSet<String>();
        HashMap<String, ICriterion> criterionMap = new HashMap<String, ICriterion>();
        for (Map.Entry<String, Criterion> entry : new HashMap<String, Criterion>(criteriaIn).entrySet()) {
            ICriterion criterion;
            IMixinCriterion mixinCriterion = (IMixinCriterion)entry.getValue();
            if (mixinCriterion.getScoreGoal() != null) {
                criterion = new SpongeScoreCriterion(entry.getKey(), mixinCriterion.getScoreGoal(), entry.getValue().func_192143_a());
                scoreCriteria.add(entry.getKey());
                ((SpongeScoreCriterion)criterion).internalCriteria.forEach(criterion1 -> criteriaIn.put(criterion1.getName(), (Criterion)criterion1));
            } else {
                criterion = (ICriterion)((Object)mixinCriterion);
                ((IMixinCriterion)((Object)criterion)).setName(entry.getKey());
            }
            criterionMap.put(entry.getKey(), criterion);
        }
        ArrayList<String[]> entries = new ArrayList<String[]>();
        ArrayList<AdvancementCriterion> andCriteria = new ArrayList<AdvancementCriterion>();
        for (String[] array : requirementsIn) {
            HashSet<AdvancementCriterion> orCriteria = new HashSet<AdvancementCriterion>();
            for (String name : array) {
                ICriterion criterion = (ICriterion)criterionMap.get(name);
                if (criterion instanceof SpongeScoreCriterion) {
                    ((SpongeScoreCriterion)criterion).internalCriteria.forEach(criterion1 -> entries.add(new String[]{criterion1.getName()}));
                } else {
                    entries.add(new String[]{criterion.getName()});
                }
                orCriteria.add(criterion);
            }
            andCriteria.add(OrCriterion.of(orCriteria));
        }
        this.criterion = AndCriterion.of(andCriteria);
        if (!scoreCriteria.isEmpty()) {
            scoreCriteria.forEach(criteriaIn::remove);
            this.field_192080_e = ImmutableMap.copyOf(criteriaIn);
            this.field_192081_f = (String[][])entries.toArray((T[])new String[entries.size()][]);
        }
    }

    @Override
    public Optional<AdvancementTree> getTree() {
        return Optional.ofNullable(this.tree);
    }

    @Override
    public void setParent(@Nullable net.minecraft.advancements.Advancement advancement) {
        this.field_192076_a = advancement;
    }

    @Override
    public void setTree(AdvancementTree tree) {
        this.tree = tree;
    }

    @Override
    public Collection<Advancement> getChildren() {
        return ImmutableList.copyOf(this.field_192082_g);
    }

    @Override
    public AdvancementCriterion getCriterion() {
        return this.criterion;
    }

    @Override
    public void setCriterion(AdvancementCriterion criterion) {
        this.criterion = criterion;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isRegistered() {
        return this.tempParent == null;
    }

    @Override
    public void setRegistered() {
        if (this.tempParent == null) {
            return;
        }
        this.field_192076_a = this.tempParent;
        this.tempParent = null;
    }

    @Override
    public Optional<Advancement> getParent() {
        if (this.tempParent != null) {
            return Optional.of((Advancement)this.tempParent);
        }
        if (this.field_192076_a == SpongeAdvancementBuilder.DUMMY_ROOT_ADVANCEMENT) {
            return Optional.empty();
        }
        return Optional.ofNullable((Advancement)this.field_192076_a);
    }

    @Override
    public Optional<org.spongepowered.api.advancement.DisplayInfo> getDisplayInfo() {
        return Optional.ofNullable((org.spongepowered.api.advancement.DisplayInfo)this.field_192077_b);
    }

    @Override
    public List<Text> toToastText() {
        return this.toastText;
    }

    @Override
    public String getId() {
        return this.spongeId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Text toText() {
        return this.text;
    }
}

