/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.minecraft;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.OrderedInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.RealLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;

public class LargeChestInventoryLens
extends RealLens {
    private int upperChest;
    private int lowerChest;

    public LargeChestInventoryLens(InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots) {
        super(0, adapter.getFabric().getSize(), (Class<? extends Inventory>)OrderedInventoryAdapter.class, slots);
        InventoryLargeChest inventory = (InventoryLargeChest)adapter;
        this.upperChest = inventory.field_70477_b.func_70302_i_();
        this.lowerChest = inventory.field_70478_c.func_70302_i_();
        this.initLargeChest(slots);
    }

    public LargeChestInventoryLens(int base, InventoryAdapter<IInventory, ItemStack> adapter, SlotProvider<IInventory, ItemStack> slots) {
        super(base, adapter.getFabric().getSize(), (Class<? extends Inventory>)OrderedInventoryAdapter.class, slots);
        InventoryLargeChest inventory = (InventoryLargeChest)adapter.getFabric().get(0);
        this.upperChest = inventory.field_70477_b.func_70302_i_();
        this.lowerChest = inventory.field_70478_c.func_70302_i_();
        this.initLargeChest(slots);
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
    }

    private void initLargeChest(SlotProvider<IInventory, ItemStack> slots) {
        int base = 0;
        this.addSpanningChild(new GridInventoryLensImpl(base, 9, this.upperChest / 9, 9, TileEntityChest.class, slots), new InventoryProperty[0]);
        this.addSpanningChild(new GridInventoryLensImpl(base += this.upperChest, 9, this.lowerChest / 9, 9, TileEntityChest.class, slots), new InventoryProperty[0]);
        base += this.lowerChest;
        this.addChild(new GridInventoryLensImpl(0, 9, (this.upperChest + this.lowerChest) / 9, 9, slots), new InventoryProperty[0]);
        int ord = 0;
        int slot = this.base;
        while (ord < base) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            ++slot;
        }
        for (int i = base; i < this.slotCount(); ++i) {
            this.addSpanningChild(new SlotLensImpl(i), SlotIndex.of(i));
        }
    }
}

