/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.comp;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.CraftingInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.CraftingGridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.CraftingInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingGridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.slots.CraftingOutputSlotLens;

public class CraftingInventoryLensImpl
extends OrderedInventoryLensImpl
implements CraftingInventoryLens<IInventory, ItemStack> {
    private final int outputSlotIndex;
    private final CraftingOutputSlotLens<IInventory, ItemStack> outputSlot;
    private final CraftingGridInventoryLens<IInventory, ItemStack> craftingGrid;

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, SlotProvider<IInventory, ItemStack> slots) {
        this(outputSlotIndex, gridBase, width, height, CraftingInventoryAdapter.class, slots);
    }

    public CraftingInventoryLensImpl(int outputSlotIndex, int gridBase, int width, int height, Class<? extends Inventory> adapterType, SlotProvider<IInventory, ItemStack> slots) {
        super(gridBase, width * height, 1, adapterType, slots);
        this.outputSlotIndex = outputSlotIndex;
        this.outputSlot = (CraftingOutputSlotLens)slots.getSlot(this.outputSlotIndex);
        this.craftingGrid = new CraftingGridInventoryLensImpl(this.base, width, height, width, slots);
        ++this.size;
        this.initOther();
    }

    @Override
    protected void init(SlotProvider<IInventory, ItemStack> slots) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlot(slot), new SlotIndex(ord));
            ++ord;
            slot += this.stride;
        }
    }

    private void initOther() {
        this.addSpanningChild(this.outputSlot, new InventoryProperty[0]);
        this.addSpanningChild(this.craftingGrid, new InventoryProperty[0]);
        this.cache();
    }

    @Override
    public CraftingGridInventoryLens<IInventory, ItemStack> getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public CraftingOutputSlotLens<IInventory, ItemStack> getOutputSlot() {
        return this.outputSlot;
    }

    @Override
    public ItemStack getOutputStack(Fabric<IInventory> inv) {
        return (ItemStack)this.outputSlot.getStack(inv);
    }

    @Override
    public boolean setOutputStack(Fabric<IInventory> inv, ItemStack stack) {
        return this.outputSlot.setStack(inv, stack);
    }

    @Override
    public int getRealIndex(Fabric<IInventory> inv, int ordinal) {
        if (!this.checkOrdinal(ordinal)) {
            return -1;
        }
        if (ordinal < this.size - 1) {
            return super.getRealIndex(inv, ordinal);
        }
        return this.outputSlotIndex;
    }

    @Override
    public InventoryAdapter<IInventory, ItemStack> getAdapter(Fabric<IInventory> inv, Inventory parent) {
        return new CraftingInventoryAdapter(inv, this, parent);
    }
}

