/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl.comp;

import java.util.Optional;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.property.SlotPos;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.Inventory2D;
import org.spongepowered.common.item.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.item.inventory.adapter.impl.VanillaAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.comp.OrderedInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.comp.OrderedInventoryLens;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;

public class Inventory2DAdapter
extends OrderedInventoryAdapter
implements Inventory2D {
    protected Inventory2DLens<IInventory, net.minecraft.item.ItemStack> lens2d;

    public Inventory2DAdapter(Fabric<IInventory> inventory, Inventory2DLens<IInventory, net.minecraft.item.ItemStack> root) {
        this(inventory, root, (Inventory)null);
    }

    public Inventory2DAdapter(Fabric<IInventory> inventory, Inventory2DLens<IInventory, net.minecraft.item.ItemStack> root, Inventory parent) {
        super(inventory, (OrderedInventoryLens<IInventory, net.minecraft.item.ItemStack>)root, parent);
        this.lens2d = root;
    }

    protected SlotLens<IInventory, net.minecraft.item.ItemStack> getSlotLens(int x, int y) {
        return this.getSlotLens(SlotPos.of(x, y));
    }

    protected SlotLens<IInventory, net.minecraft.item.ItemStack> getSlotLens(SlotPos pos) {
        try {
            return this.lens2d.getSlot(pos);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public Optional<Slot> getSlot(SlotPos pos) {
        return VanillaAdapter.forSlot(this.inventory, this.getSlotLens(pos), this);
    }

    @Override
    public Optional<ItemStack> poll(SlotPos pos) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(pos));
    }

    @Override
    public Optional<ItemStack> poll(SlotPos pos, int limit) {
        return AdapterLogic.pollSequential(this.inventory, this.getSlotLens(pos), limit);
    }

    @Override
    public Optional<ItemStack> peek(SlotPos pos) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(pos));
    }

    @Override
    public Optional<ItemStack> peek(SlotPos pos, int limit) {
        return AdapterLogic.peekSequential(this.inventory, this.getSlotLens(pos), limit);
    }

    @Override
    public InventoryTransactionResult set(SlotPos pos, ItemStack stack) {
        return AdapterLogic.insertSequential(this.inventory, this.getSlotLens(pos), stack);
    }
}

