/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.play.client.CPacketEnchantItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InventoryPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class EnchantItemPacketState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
        if (!mixinContainer.capturingInventory()) {
            mixinContainer.getCapturedTransactions().clear();
            return;
        }
        CPacketEnchantItem packetIn = (CPacketEnchantItem)context.getPacket();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        Container openContainer = player.field_71070_bA;
        List<SlotTransaction> slotTransactions = mixinContainer.getCapturedTransactions();
        int usedButton = packetIn.func_149537_d();
        ArrayList<org.spongepowered.api.entity.Entity> capturedItems = new ArrayList<org.spongepowered.api.entity.Entity>();
        for (EntityItem entityItem : context.getCapturedItems()) {
            capturedItems.add(EntityUtil.fromNative((Entity)entityItem));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getCauseStackManager().pushCause(player);
            Sponge.getCauseStackManager().pushCause(openContainer);
            ClickInventoryEvent inventoryEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(openContainer), transaction, Lists.newArrayList(slotTransactions), capturedItems, usedButton);
            if (mixinContainer.getCapturedTransactions().isEmpty() && capturedItems.isEmpty()) {
                mixinContainer.setCaptureInventory(false);
                return;
            }
            if (inventoryEvent != null) {
                if (inventoryEvent instanceof AffectEntityEvent && ((AffectEntityEvent)((Object)inventoryEvent)).getEntities().isEmpty()) {
                    slotTransactions.clear();
                    mixinContainer.setCaptureInventory(false);
                    return;
                }
                if (!(inventoryEvent instanceof ClickInventoryEvent.Drag)) {
                    PacketPhaseUtil.validateCapturedTransactions(packetIn.func_149539_c(), openContainer, inventoryEvent.getTransactions());
                }
                SpongeImpl.postEvent(inventoryEvent);
                if (inventoryEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(inventoryEvent.getTransactions())) {
                    if (inventoryEvent instanceof ClickInventoryEvent.Drop) {
                        capturedItems.clear();
                    }
                    PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getOriginal());
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, inventoryEvent.getTransactions(), true);
                } else {
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, openContainer, inventoryEvent.getTransactions(), false);
                    if (!inventoryEvent.getCursorTransaction().isValid()) {
                        PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getOriginal());
                    } else if (inventoryEvent.getCursorTransaction().getCustom().isPresent()) {
                        PacketPhaseUtil.handleCustomCursor(player, inventoryEvent.getCursorTransaction().getFinal());
                    } else if (inventoryEvent instanceof ClickInventoryEvent.Drag) {
                        int increment = slotTransactions.stream().filter(t -> !t.isValid()).mapToInt(t -> ((ItemStackSnapshot)t.getFinal()).getQuantity()).sum();
                        ItemStack cursor = inventoryEvent.getCursorTransaction().getFinal().createStack();
                        cursor.setQuantity(cursor.getQuantity() + increment);
                        PacketPhaseUtil.handleCustomCursor(player, cursor.createSnapshot());
                    } else if (inventoryEvent instanceof ClickInventoryEvent.Double && !(inventoryEvent instanceof ClickInventoryEvent.Shift)) {
                        int decrement = slotTransactions.stream().filter(t -> !t.isValid()).mapToInt(t -> ((ItemStackSnapshot)t.getOriginal()).getQuantity()).sum();
                        ItemStack cursor = inventoryEvent.getCursorTransaction().getFinal().createStack();
                        cursor.setQuantity(cursor.getQuantity() - decrement);
                        PacketPhaseUtil.handleCustomCursor(player, cursor.createSnapshot());
                    }
                    if (inventoryEvent instanceof SpawnEntityEvent) {
                        EnchantItemPacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)inventoryEvent));
                    } else if (!context.getCapturedEntitySupplier().isEmpty()) {
                        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), context.getCapturedEntities());
                        SpongeImpl.postEvent(spawnEntityEvent);
                        if (!spawnEntityEvent.isCancelled()) {
                            EnchantItemPacketState.processSpawnedEntities(player, spawnEntityEvent);
                        }
                    }
                }
            }
        }
        slotTransactions.clear();
        mixinContainer.setCaptureInventory(false);
    }
}

