/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class AttackEntityPacketState
extends BasicPacketState {
    AttackEntityPacketState() {
    }

    @Override
    public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)packetIn;
        Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, BasicPacketContext context) {
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184614_ca());
        if (stack != null) {
            context.itemUsed(stack);
        }
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        CPacketUseEntity useEntityPacket = (CPacketUseEntity)context.getPacket();
        Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = EntityUtil.getSpongeWorld((Entity)player);
        EntityUtil.toMixin(entity).setNotifier(player.func_110124_au());
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Processing Attack Entity").centre().hr();
            printer.add("There are some captured items after the entity was destructed!");
            printer.addWrapped(60, "%s : %s", "Items captured", items);
            printer.add("Stacktrace:");
            printer.add(new Exception("Stack trace"));
            printer.trace(System.err, SpongeImpl.getLogger(), Level.TRACE);
        });
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
        context.getCapturedEntityDropSupplier().acceptIfNotEmpty(map -> {
            for (Map.Entry entry : map.asMap().entrySet()) {
                UUID key = (UUID)entry.getKey();
                Optional<org.spongepowered.api.entity.Entity> affectedEntity = spongeWorld.getEntity(key);
                if (!affectedEntity.isPresent()) continue;
                Collection itemStacks = (Collection)entry.getValue();
                if (itemStacks.isEmpty()) {
                    return;
                }
                ArrayList items = new ArrayList(itemStacks);
                if (items.isEmpty()) continue;
                CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                Throwable throwable = null;
                try {
                    List itemEntities = items.stream().map(data -> data.create((WorldServer)player.field_70170_p)).map(EntityUtil::fromNative).collect(Collectors.toList());
                    Sponge.getCauseStackManager().pushCause(player);
                    Sponge.getCauseStackManager().pushCause(affectedEntity.get());
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                    DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), itemEntities);
                    SpongeImpl.postEvent(destruct);
                    if (destruct.isCancelled()) continue;
                    AttackEntityPacketState.processSpawnedEntities(player, destruct);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (frame == null) continue;
                    if (throwable != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    frame.close();
                }
            }
        });
        context.getCapturedEntityItemDropSupplier().acceptIfNotEmpty(map -> {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(player);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.DROPPED_ITEM);
                for (Map.Entry entry : map.asMap().entrySet()) {
                    UUID key = (UUID)entry.getKey();
                    Optional<org.spongepowered.api.entity.Entity> attackedEntities = spongeWorld.getEntity(key);
                    if (!attackedEntities.isPresent()) continue;
                    List items = ((Collection)entry.getValue()).stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                    DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), items);
                    SpongeImpl.postEvent(destruct);
                    if (destruct.isCancelled()) continue;
                    AttackEntityPacketState.processSpawnedEntities(player, destruct);
                }
            }
        });
    }
}

