/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.entity.BasicEntityContext;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DeathUpdateState
extends EntityPhaseState<BasicEntityContext> {
    DeathUpdateState() {
    }

    @Override
    public BasicEntityContext createPhaseContext() {
        return (BasicEntityContext)((BasicEntityContext)new BasicEntityContext(this).addCaptures()).addEntityDropCaptures();
    }

    @Override
    public void unwind(BasicEntityContext context) {
        org.spongepowered.api.entity.Entity dyingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            DamageSource damageSource = context.getDamageSource();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Sponge.getCauseStackManager().pushCause(dyingEntity);
                Sponge.getCauseStackManager().pushCause(damageSource);
                Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), entities);
                SpongeImpl.postEvent(destruct);
                if (!destruct.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            }
        });
        context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> {
            List other;
            List experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
            if (!experience.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    Sponge.getCauseStackManager().pushCause(dyingEntity);
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                    SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), experience);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity2 : event.getEntities()) {
                            EntityUtil.getMixinWorld(entity2).forceSpawnEntity(entity2);
                        }
                    }
                }
            }
            if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    Sponge.getCauseStackManager().pushCause(dyingEntity);
                    Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, InternalSpawnTypes.ENTITY_DEATH);
                    SpawnEntityEvent event1 = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), other);
                    SpongeImpl.postEvent(event1);
                    if (!event1.isCancelled()) {
                        for (org.spongepowered.api.entity.Entity entity3 : event1.getEntities()) {
                            EntityUtil.getMixinWorld(entity3).forceSpawnEntity(entity3);
                        }
                    }
                }
            }
        });
        context.getCapturedEntityDropSupplier().acceptIfNotEmpty(map -> {
            if (map.isEmpty()) {
                return;
            }
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing Entity Death Updates Spawning").centre().hr();
            printer.add("Entity Dying: " + dyingEntity);
            printer.add("The item stacks captured are: ");
            for (Map.Entry entry : map.asMap().entrySet()) {
                printer.add("  - Entity with UUID: %s", entry.getKey());
                for (ItemDropData stack : (Collection)entry.getValue()) {
                    printer.add("    - %s", stack);
                }
            }
            printer.trace(System.err);
        });
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
    }
}

