/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.base.Preconditions;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.event.damage.MinecraftBlockDamageSource;

public class SpongeBlockDamageSourceBuilder
extends AbstractDamageSourceBuilder<BlockDamageSource, BlockDamageSource.Builder>
implements BlockDamageSource.Builder {
    private Location<World> location;
    private BlockSnapshot blockSnapshot;

    @Override
    public BlockDamageSource.Builder block(Location<World> location) {
        this.location = location;
        return this;
    }

    @Override
    public BlockDamageSource.Builder block(BlockSnapshot blockState) {
        this.blockSnapshot = (BlockSnapshot)Preconditions.checkNotNull((Object)blockState);
        return this;
    }

    @Override
    public BlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.location != null ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSnapshot != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftBlockDamageSource damageSource = new MinecraftBlockDamageSource(this.damageType.getId(), this.location);
        if (this.absolute) {
            damageSource.func_151518_m();
        }
        if (this.bypasses) {
            damageSource.func_76348_h();
        }
        if (this.scales) {
            damageSource.func_76351_m();
        }
        if (this.explosion) {
            damageSource.func_94540_d();
        }
        if (this.magical) {
            damageSource.func_82726_p();
        }
        if (this.creative) {
            damageSource.func_76359_i();
        }
        if (this.exhaustion != null) {
            damageSource.field_76384_q = this.exhaustion.floatValue();
        }
        return (BlockDamageSource)((Object)damageSource);
    }

    @Override
    public BlockDamageSource.Builder reset() {
        super.reset();
        this.location = null;
        this.blockSnapshot = null;
        return this;
    }
}

