/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFuseData;
import org.spongepowered.api.data.manipulator.mutable.entity.FuseData;
import org.spongepowered.api.entity.explosive.FusedExplosive;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFuseData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.entity.explosive.IMixinFusedExplosive;

public class FuseDataProcessor
extends AbstractMultiDataSingleTargetProcessor<FusedExplosive, FuseData, ImmutableFuseData> {
    public FuseDataProcessor() {
        super(FusedExplosive.class);
    }

    @Override
    protected boolean doesDataExist(FusedExplosive dataHolder) {
        return true;
    }

    @Override
    protected boolean set(FusedExplosive explosive, Map<Key<?>, Object> keyValues) {
        Integer fuseDuration = (Integer)keyValues.get(Keys.FUSE_DURATION);
        Integer ticksRemaining = (Integer)keyValues.get(Keys.TICKS_REMAINING);
        Preconditions.checkArgument((fuseDuration >= 0 ? 1 : 0) != 0, (Object)"fuse cannot be less than zero");
        Preconditions.checkArgument((ticksRemaining >= 0 ? 1 : 0) != 0, (Object)"remaining ticks cannot be less than zero");
        IMixinFusedExplosive mixin = (IMixinFusedExplosive)((Object)explosive);
        mixin.setFuseDuration(fuseDuration);
        if (explosive.isPrimed()) {
            mixin.setFuseTicksRemaining(ticksRemaining);
        }
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(FusedExplosive explosive) {
        IMixinFusedExplosive mixin = (IMixinFusedExplosive)((Object)explosive);
        return ImmutableMap.of(Keys.FUSE_DURATION, (Object)mixin.getFuseDuration(), Keys.TICKS_REMAINING, (Object)mixin.getFuseTicksRemaining());
    }

    @Override
    protected FuseData createManipulator() {
        return new SpongeFuseData();
    }

    @Override
    public Optional<FuseData> fill(DataContainer container, FuseData fuseData) {
        fuseData.set(Keys.FUSE_DURATION, DataUtil.getData(container, Keys.FUSE_DURATION));
        fuseData.set(Keys.TICKS_REMAINING, DataUtil.getData(container, Keys.TICKS_REMAINING));
        return Optional.of(fuseData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

