/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDespawnDelayData;
import org.spongepowered.api.data.manipulator.mutable.entity.DespawnDelayData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDespawnDelayData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.entity.item.IMixinEntityItem;

public final class DespawnDelayDataProcessor
extends AbstractEntityDataProcessor<EntityItem, DespawnDelayData, ImmutableDespawnDelayData> {
    public DespawnDelayDataProcessor() {
        super(EntityItem.class);
    }

    @Override
    protected boolean doesDataExist(EntityItem container) {
        return true;
    }

    @Override
    protected boolean set(EntityItem container, Map<Key<?>, Object> keyValues) {
        ((IMixinEntityItem)container).setDespawnDelay((Integer)keyValues.get(Keys.DESPAWN_DELAY), (Boolean)keyValues.get(Keys.INFINITE_DESPAWN_DELAY));
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityItem container) {
        return ImmutableMap.builder().put(Keys.DESPAWN_DELAY, (Object)((IMixinEntityItem)container).getDespawnDelay()).put(Keys.INFINITE_DESPAWN_DELAY, (Object)((IMixinEntityItem)container).infiniteDespawnDelay()).build();
    }

    @Override
    protected DespawnDelayData createManipulator() {
        return new SpongeDespawnDelayData();
    }

    @Override
    public Optional<DespawnDelayData> fill(DataContainer container, DespawnDelayData data) {
        data.set(Keys.DESPAWN_DELAY, DataUtil.getData(container, Keys.DESPAWN_DELAY));
        data.set(Keys.INFINITE_DESPAWN_DELAY, DataUtil.getData(container, Keys.INFINITE_DESPAWN_DELAY));
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder container) {
        return DataTransactionResult.failNoData();
    }
}

