/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDamageableData;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeDamageableData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;

public class SpongeDamageableData
extends AbstractData<DamageableData, ImmutableDamageableData>
implements DamageableData {
    @Nullable
    private EntitySnapshot lastAttacker;
    @Nullable
    private Double lastDamage;

    public SpongeDamageableData() {
        this((EntitySnapshot)null, null);
    }

    public SpongeDamageableData(@Nullable EntitySnapshot lastAttacker, @Nullable Double lastDamage) {
        super(DamageableData.class);
        this.lastAttacker = lastAttacker;
        this.lastDamage = lastDamage;
    }

    public SpongeDamageableData(@Nullable Living lastAttacker, @Nullable Double lastDamage) {
        this(lastAttacker == null ? null : lastAttacker.createSnapshot(), lastDamage);
    }

    @Override
    public OptionalValue<EntitySnapshot> lastAttacker() {
        return new SpongeOptionalValue<EntitySnapshot>(Keys.LAST_ATTACKER, Optional.empty(), Optional.ofNullable(this.lastAttacker));
    }

    @Override
    public OptionalValue<Double> lastDamage() {
        return new SpongeOptionalValue<Double>(Keys.LAST_DAMAGE, Optional.empty(), Optional.ofNullable(this.lastAttacker == null ? null : this.lastDamage));
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.LAST_ATTACKER, () -> Optional.ofNullable(this.lastAttacker));
        this.registerFieldSetter(Keys.LAST_ATTACKER, lastAttacker -> {
            this.lastAttacker = lastAttacker == null ? null : (EntitySnapshot)lastAttacker.orElse(null);
        });
        this.registerKeyValue(Keys.LAST_ATTACKER, this::lastAttacker);
        this.registerFieldGetter(Keys.LAST_DAMAGE, () -> Optional.ofNullable(this.lastDamage));
        this.registerFieldSetter(Keys.LAST_DAMAGE, lastDamage -> {
            this.lastDamage = lastDamage == null ? null : (Double)lastDamage.orElse(null);
        });
        this.registerKeyValue(Keys.LAST_DAMAGE, this::lastDamage);
    }

    @Override
    public DamageableData copy() {
        return new SpongeDamageableData(this.lastAttacker, this.lastDamage);
    }

    @Override
    public ImmutableDamageableData asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDamageableData.class, this.lastAttacker, this.lastDamage);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.LAST_ATTACKER, (Object)Optional.ofNullable(this.lastAttacker)).set(Keys.LAST_DAMAGE, (Object)Optional.ofNullable(this.lastDamage));
    }
}

