/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.spec;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.args.parsing.InputTokenizer;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public final class CommandSpec
implements CommandCallable {
    private final CommandElement args;
    private final CommandExecutor executor;
    private final Optional<Text> description;
    private final Optional<Text> extendedDescription;
    @Nullable
    private final String permission;
    private final InputTokenizer argumentParser;

    CommandSpec(CommandElement args, CommandExecutor executor, @Nullable Text description, @Nullable Text extendedDescription, @Nullable String permission, InputTokenizer parser) {
        this.args = args;
        this.executor = executor;
        this.permission = permission;
        this.description = Optional.ofNullable(description);
        this.extendedDescription = Optional.ofNullable(extendedDescription);
        this.argumentParser = parser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void checkPermission(CommandSource source) throws CommandException {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        if (!this.testPermission(source)) {
            throw new CommandPermissionException();
        }
    }

    public void populateContext(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        this.args.parse(source, args, context);
        if (args.hasNext()) {
            args.next();
            throw args.createError(SpongeApiTranslationHelper.t("Too many arguments!", new Object[0]));
        }
    }

    public List<String> complete(CommandSource source, CommandArgs args, CommandContext context) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        List<String> ret = this.args.complete(source, args, context);
        return ret == null ? ImmutableList.of() : ImmutableList.copyOf(ret);
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public InputTokenizer getInputTokenizer() {
        return this.argumentParser;
    }

    @Override
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        this.checkPermission(source);
        CommandArgs args = new CommandArgs(arguments, this.getInputTokenizer().tokenize(arguments, false));
        CommandContext context = new CommandContext();
        this.populateContext(source, args, context);
        return this.getExecutor().execute(source, context);
    }

    @Override
    public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPos) throws CommandException {
        CommandArgs args = new CommandArgs(arguments, this.getInputTokenizer().tokenize(arguments, true));
        CommandContext ctx = new CommandContext();
        if (targetPos != null) {
            ctx.putArg("targetblock-pos048658", targetPos);
        }
        return this.complete(source, args, ctx);
    }

    @Override
    public boolean testPermission(CommandSource source) {
        return this.permission == null || source.hasPermission(this.permission);
    }

    @Override
    public Optional<Text> getShortDescription(CommandSource source) {
        return this.description;
    }

    public Optional<Text> getExtendedDescription(CommandSource source) {
        return this.extendedDescription;
    }

    @Override
    public Text getUsage(CommandSource source) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        return this.args.getUsage(source);
    }

    @Override
    public Optional<Text> getHelp(CommandSource source) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        Text.Builder builder = Text.builder();
        this.getShortDescription(source).ifPresent(a -> builder.append((Text)a, Text.NEW_LINE));
        builder.append(this.getUsage(source));
        this.getExtendedDescription(source).ifPresent(a -> builder.append(Text.NEW_LINE, (Text)a));
        return Optional.of(builder.build());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandSpec that = (CommandSpec)o;
        return Objects.equal((Object)this.args, (Object)that.args) && Objects.equal((Object)this.executor, (Object)that.executor) && Objects.equal(this.description, that.description) && Objects.equal(this.extendedDescription, that.extendedDescription) && Objects.equal((Object)this.permission, (Object)that.permission) && Objects.equal((Object)this.argumentParser, (Object)that.argumentParser);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.args, this.executor, this.description, this.extendedDescription, this.permission, this.argumentParser});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("args", (Object)this.args).add("executor", (Object)this.executor).add("description", this.description).add("extendedDescription", this.extendedDescription).add("permission", (Object)this.permission).add("argumentParser", (Object)this.argumentParser).toString();
    }

    public static final class Builder {
        private static final CommandElement DEFAULT_ARG = GenericArguments.none();
        private CommandElement args = DEFAULT_ARG;
        @Nullable
        private Text description;
        @Nullable
        private Text extendedDescription;
        @Nullable
        private String permission;
        @Nullable
        private CommandExecutor executor;
        @Nullable
        private Map<List<String>, CommandCallable> childCommandMap;
        private boolean childCommandFallback = true;
        private InputTokenizer argumentParser = InputTokenizer.quotedStrings(false);

        Builder() {
        }

        public Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Builder executor(CommandExecutor executor) {
            Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.executor = executor;
            return this;
        }

        public Builder children(Map<List<String>, ? extends CommandCallable> children) {
            Preconditions.checkNotNull(children, (Object)"children");
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<List<String>, CommandCallable>();
            }
            this.childCommandMap.putAll(children);
            return this;
        }

        public Builder child(CommandCallable child, String ... aliases) {
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<List<String>, CommandCallable>();
            }
            this.childCommandMap.put((List<String>)ImmutableList.copyOf((Object[])aliases), child);
            return this;
        }

        public Builder child(CommandCallable child, Collection<String> aliases) {
            if (this.childCommandMap == null) {
                this.childCommandMap = new HashMap<List<String>, CommandCallable>();
            }
            this.childCommandMap.put((List<String>)ImmutableList.copyOf(aliases), child);
            return this;
        }

        public Builder description(@Nullable Text description) {
            this.description = description;
            return this;
        }

        public Builder extendedDescription(@Nullable Text extendedDescription) {
            this.extendedDescription = extendedDescription;
            return this;
        }

        public Builder childArgumentParseExceptionFallback(boolean childCommandFallback) {
            this.childCommandFallback = childCommandFallback;
            return this;
        }

        public Builder arguments(CommandElement args) {
            Preconditions.checkNotNull((Object)args, (Object)"args");
            this.args = args;
            return this;
        }

        public Builder arguments(CommandElement ... args) {
            Preconditions.checkNotNull((Object)args, (Object)"args");
            this.args = GenericArguments.seq(args);
            return this;
        }

        public Builder inputTokenizer(InputTokenizer parser) {
            Preconditions.checkNotNull((Object)parser, (Object)"parser");
            this.argumentParser = parser;
            return this;
        }

        public CommandSpec build() {
            if (this.childCommandMap == null || this.childCommandMap.isEmpty()) {
                Preconditions.checkNotNull((Object)this.executor, (Object)"An executor is required");
            } else if (this.executor == null) {
                ChildCommandElementExecutor childCommandElementExecutor = this.registerInDispatcher(new ChildCommandElementExecutor(null, null, false));
                if (this.args == DEFAULT_ARG) {
                    this.arguments((CommandElement)childCommandElementExecutor);
                } else {
                    this.arguments(this.args, childCommandElementExecutor);
                }
            } else {
                this.arguments((CommandElement)this.registerInDispatcher(new ChildCommandElementExecutor(this.executor, this.args, this.childCommandFallback)));
            }
            return new CommandSpec(this.args, this.executor, this.description, this.extendedDescription, this.permission, this.argumentParser);
        }

        private ChildCommandElementExecutor registerInDispatcher(ChildCommandElementExecutor childDispatcher) {
            for (Map.Entry<List<String>, CommandCallable> spec : this.childCommandMap.entrySet()) {
                childDispatcher.register(spec.getValue(), spec.getKey());
            }
            this.executor(childDispatcher);
            return childDispatcher;
        }
    }
}

