/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.craftinggrid.IItemKey;
import mcjty.rftools.craftinggrid.IItemSource;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityItemSource
implements IItemSource {
    private List<Pair<Object, Integer>> inventories = new ArrayList<Pair<Object, Integer>>();

    public TileEntityItemSource add(TileEntity te, int offset) {
        if (RFToolsTools.hasItemCapabilitySafe(te)) {
            IItemHandler capability = RFToolsTools.getItemCapabilitySafe(te);
            this.inventories.add((Pair<Object, Integer>)Pair.of((Object)capability, (Object)offset));
        } else if (te instanceof IInventory) {
            this.inventories.add((Pair<Object, Integer>)Pair.of((Object)te, (Object)offset));
        }
        return this;
    }

    public TileEntityItemSource addInventory(IInventory te, int offset) {
        this.inventories.add((Pair<Object, Integer>)Pair.of((Object)te, (Object)offset));
        return this;
    }

    private static ItemStack getStackInSlot(Object inv, int slot) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getStackInSlot(slot);
        }
        if (inv instanceof IInventory) {
            return ((IInventory)inv).func_70301_a(slot);
        }
        return ItemStackTools.getEmptyStack();
    }

    private static boolean insertStackInSlot(Object inv, int slot, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            if (ItemStackTools.isValid((ItemStack)handler.insertItem(slot, stack, true))) {
                return false;
            }
            return ItemStackTools.isEmpty((ItemStack)handler.insertItem(slot, stack, false));
        }
        if (inv instanceof IInventory) {
            IInventory inventory = (IInventory)inv;
            ItemStack oldStack = inventory.func_70301_a(slot);
            if (ItemStackTools.isValid((ItemStack)oldStack)) {
                if (ItemStackTools.getStackSize((ItemStack)stack) + ItemStackTools.getStackSize((ItemStack)oldStack) > stack.func_77976_d()) {
                    return false;
                }
                ItemStackTools.incStackSize((ItemStack)stack, (int)ItemStackTools.getStackSize((ItemStack)oldStack));
            }
            inventory.func_70299_a(slot, stack);
            return true;
        }
        return false;
    }

    private static int insertStackInAnySlot(Object inv, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            ItemStack leftOver = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            return ItemStackTools.getStackSize((ItemStack)leftOver);
        }
        if (inv instanceof IInventory) {
            IInventory inventory = (IInventory)inv;
            return InventoryHelper.mergeItemStack((IInventory)inventory, (boolean)true, (ItemStack)stack, (int)0, (int)inventory.func_70302_i_(), null);
        }
        return ItemStackTools.getStackSize((ItemStack)stack);
    }

    private static int getSizeInventory(Object inv) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getSlots();
        }
        if (inv instanceof IInventory) {
            return ((IInventory)inv).func_70302_i_();
        }
        return 0;
    }

    @Override
    public Iterable<Pair<IItemKey, ItemStack>> getItems() {
        return () -> new Iterator<Pair<IItemKey, ItemStack>>(){
            private int inventoryIndex = 0;
            private int slotIndex = 0;

            private boolean firstValidItem() {
                while (this.inventoryIndex < TileEntityItemSource.this.inventories.size()) {
                    Object inventory = ((Pair)TileEntityItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                    if (this.slotIndex < TileEntityItemSource.getSizeInventory(inventory)) {
                        return true;
                    }
                    this.slotIndex = 0;
                    ++this.inventoryIndex;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.firstValidItem();
            }

            @Override
            public Pair<IItemKey, ItemStack> next() {
                Object te = ((Pair)TileEntityItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                ItemKey key = new ItemKey(te, this.slotIndex);
                Pair result = Pair.of((Object)key, (Object)TileEntityItemSource.getStackInSlot(te, this.slotIndex));
                ++this.slotIndex;
                return result;
            }
        };
    }

    @Override
    public ItemStack decrStackSize(IItemKey key, int amount) {
        ItemKey realKey = (ItemKey)key;
        Object te = realKey.getInventory();
        if (te instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)te;
            return handler.extractItem(realKey.getSlot(), amount, false);
        }
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            ItemStack stack = inventory.func_70301_a(realKey.getSlot());
            ItemStack result = stack.func_77979_a(amount);
            if (ItemStackTools.isEmpty((ItemStack)stack)) {
                inventory.func_70299_a(realKey.getSlot(), ItemStackTools.getEmptyStack());
            }
            return result;
        }
        return ItemStackTools.getEmptyStack();
    }

    @Override
    public boolean insertStack(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInSlot(realKey.getInventory(), realKey.getSlot(), stack);
    }

    @Override
    public int insertStackAnySlot(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInAnySlot(realKey.getInventory(), stack);
    }

    private static class ItemKey
    implements IItemKey {
        private Object inventory;
        private int slot;

        public ItemKey(Object inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
        }

        public Object getInventory() {
            return this.inventory;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemKey itemKey = (ItemKey)o;
            if (this.slot != itemKey.slot) {
                return false;
            }
            return this.inventory.equals(itemKey.inventory);
        }

        public int hashCode() {
            int result = this.inventory.hashCode();
            result = 31 * result + this.slot;
            return result;
        }
    }
}

