/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingGrid {
    private CraftingGridInventory craftingGridInventory = new CraftingGridInventory();
    private CraftingRecipe[] recipes = new CraftingRecipe[6];

    public CraftingGrid() {
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public CraftingGridInventory getCraftingGridInventory() {
        return this.craftingGridInventory;
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public CraftingRecipe getActiveRecipe() {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
        return recipe;
    }

    public void setRecipe(int index, ItemStack[] stacks) {
        CraftingRecipe recipe = this.recipes[index];
        recipe.setResult(stacks[0]);
        for (int i = 0; i < 9; ++i) {
            recipe.getInventory().func_70299_a(i, stacks[i + 1]);
        }
    }

    public void storeRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
    }

    public void selectRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        this.craftingGridInventory.func_70299_a(CraftingGridInventory.SLOT_GHOSTOUTPUT, recipe.getResult());
        for (int i = 0; i < 9; ++i) {
            this.craftingGridInventory.func_70299_a(i + CraftingGridInventory.SLOT_GHOSTINPUT, recipe.getInventory().func_70301_a(i));
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.craftingGridInventory.func_70302_i_(); ++i) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            ItemStack stack = this.craftingGridInventory.func_70301_a(i);
            if (ItemStackTools.isValid((ItemStack)stack)) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("grid", (NBTBase)bufferTagList);
        NBTTagList recipeTagList = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            recipe.writeToNBT(nbtTagCompound);
            recipeTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("recipes", (NBTBase)recipeTagList);
        return tagCompound;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("grid", 10);
        for (int i = 0; i < this.craftingGridInventory.func_70302_i_(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.craftingGridInventory.func_70299_a(i, ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound));
        }
        NBTTagList recipeTagList = tagCompound.func_150295_c("recipes", 10);
        for (int i = 0; i < recipeTagList.func_74745_c(); ++i) {
            this.recipes[i] = new CraftingRecipe();
            NBTTagCompound nbtTagCompound = recipeTagList.func_150305_b(i);
            this.recipes[i].readFromNBT(nbtTagCompound);
        }
    }
}

