/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental.modules;

import java.util.ArrayList;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.playerprops.BuffProperties;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BuffEModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private boolean active = false;
    private int ticks = 180;
    private final PlayerBuff buff;

    public BuffEModule(PlayerBuff buff) {
        this.buff = buff;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void tick(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.field_73010_i);
        for (EntityPlayer player : players) {
            double py = player.field_70163_u;
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.field_70165_t;
            double pz = player.field_70161_v;
            double sqdist = (px - (double)pos.func_177958_n()) * (px - (double)pos.func_177958_n()) + (pz - (double)pos.func_177952_p()) * (pz - (double)pos.func_177952_p());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            BuffProperties.addBuffToPlayer(player, this.buff, 180);
        }
    }

    @Override
    public boolean apply(World world, BlockPos pos, EntityLivingBase entity, int duration) {
        return false;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }
}

