/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRedstoneBreaker;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformerHV;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockConnector
extends BlockIETileProvider<BlockTypes_Connector> {
    public BlockConnector() {
        super("connector", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_Connector.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_ALL, IEProperties.BOOLEANS[0], IEProperties.BOOLEANS[1], IEProperties.MULTIBLOCKSLAVE, IOBJModelCallback.PROPERTY});
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.field_149786_r = 0;
        this.setBlockLayer(BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
        this.setAllNotNormalBlock();
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            return "transformer";
        }
        if (meta == BlockTypes_Connector.TRANSFORMER_HV.getMeta()) {
            return "transformer_hv";
        }
        if (meta == BlockTypes_Connector.BREAKERSWITCH.getMeta()) {
            return "breakerSwitch";
        }
        if (meta == BlockTypes_Connector.REDSTONE_BREAKER.getMeta()) {
            return "redstoneBreaker";
        }
        if (meta == BlockTypes_Connector.ENERGY_METER.getMeta()) {
            return "energyMeter";
        }
        return null;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer base = super.func_180661_e();
        IUnlistedProperty[] unlisted = base instanceof ExtendedBlockState ? ((ExtendedBlockState)base).getUnlistedProperties().toArray(new IUnlistedProperty[0]) : new IUnlistedProperty[]{};
        unlisted = Arrays.copyOf(unlisted, unlisted.length + 1);
        unlisted[unlisted.length - 1] = IEProperties.CONNECTIONS;
        return new ExtendedBlockState((Block)this, base.func_177623_d().toArray(new IProperty[0]), unlisted);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityImmersiveConnectable)) {
                return state;
            }
            state = ext.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
        }
        return state;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState s = world.func_180495_p(pos);
        return s.func_177229_b((IProperty)this.property) == BlockTypes_Connector.ENERGY_METER;
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() == BlockTypes_Connector.TRANSFORMER.getMeta() || stack.func_77952_i() == BlockTypes_Connector.TRANSFORMER_HV.getMeta()) {
            for (int hh = 1; hh <= 2; ++hh) {
                if (world.func_180495_p(pos.func_177982_a(0, hh, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, hh, 0))) continue;
                return false;
            }
        } else if (stack.func_77952_i() == BlockTypes_Connector.ENERGY_METER.getMeta() && !world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 1, 0))) {
            return false;
        }
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        TileEntityImmersiveConnectable connector;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityConnectorLV) {
            connector = (TileEntityConnectorLV)te;
            if (world.func_175623_d(pos.func_177972_a(((TileEntityConnectorLV)connector).facing))) {
                this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
                connector.func_145831_w().func_175698_g(pos);
                return;
            }
        }
        if (te instanceof TileEntityConnectorRedstone) {
            connector = (TileEntityConnectorRedstone)te;
            if (world.func_175623_d(pos.func_177972_a(((TileEntityConnectorRedstone)connector).facing))) {
                this.func_176226_b(connector.func_145831_w(), pos, world.func_180495_p(pos), 0);
                connector.func_145831_w().func_175698_g(pos);
                return;
            }
            if (((TileEntityConnectorRedstone)connector).isRSInput()) {
                ((TileEntityConnectorRedstone)connector).rsDirty = true;
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (BlockTypes_Connector.values()[meta]) {
            case CONNECTOR_LV: {
                return new TileEntityConnectorLV();
            }
            case RELAY_LV: {
                return new TileEntityRelayLV();
            }
            case CONNECTOR_MV: {
                return new TileEntityConnectorMV();
            }
            case RELAY_MV: {
                return new TileEntityRelayMV();
            }
            case CONNECTOR_HV: {
                return new TileEntityConnectorHV();
            }
            case RELAY_HV: {
                return new TileEntityRelayHV();
            }
            case CONNECTOR_STRUCTURAL: {
                return new TileEntityConnectorStructural();
            }
            case TRANSFORMER: {
                return new TileEntityTransformer();
            }
            case TRANSFORMER_HV: {
                return new TileEntityTransformerHV();
            }
            case BREAKERSWITCH: {
                return new TileEntityBreakerSwitch();
            }
            case REDSTONE_BREAKER: {
                return new TileEntityRedstoneBreaker();
            }
            case ENERGY_METER: {
                return new TileEntityEnergyMeter();
            }
            case CONNECTOR_REDSTONE: {
                return new TileEntityConnectorRedstone();
            }
        }
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState ret = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            TileEntity tile;
            BlockPos pos2 = pos.func_177967_a(facing, -1);
            IBlockState placedAgainst = world.func_180495_p(pos2);
            Block block = placedAgainst.func_177230_c();
            if (block instanceof IPostBlock && ((IPostBlock)block).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.func_177226_a((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
            if ((tile = world.func_175625_s(pos2)) instanceof IPostBlock && ((IPostBlock)tile).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.func_177226_a((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
        }
        return ret;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

