/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ThermoelectricHandler {
    static HashMap<String, Integer> temperatureMap = new HashMap();

    public static void registerSourceInKelvin(String source, int value) {
        temperatureMap.put(source, value);
    }

    public static void registerSourceInCelsius(String source, int value) {
        temperatureMap.put(source, value + 273);
    }

    public static void registerSourceInFarenheit(String source, int value) {
        temperatureMap.put(source, (int)Math.round((double)(value - 32) / 1.8 + 273.0));
    }

    public static int getTemperature(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        if (stack.func_77973_b() != null) {
            for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!temperatureMap.containsKey(OreDictionary.getOreName((int)oreID))) continue;
                return temperatureMap.get(OreDictionary.getOreName((int)oreID));
            }
        }
        return -1;
    }

    public static Map<String, Integer> getThermalValuesSorted(boolean inverse) {
        HashMap<String, Integer> existingMap = new HashMap<String, Integer>();
        for (String s : temperatureMap.keySet()) {
            if (!ApiUtils.isExistingOreName(s)) continue;
            existingMap.put(s, temperatureMap.get(s));
        }
        return ApiUtils.sortMap(existingMap, inverse);
    }
}

