/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.coloredEgg;

import com.setycz.chickens.ChickensRegistry;
import com.setycz.chickens.ChickensRegistryItem;
import com.setycz.chickens.IColorSource;
import com.setycz.chickens.coloredEgg.EntityColoredEgg;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColoredEgg
extends ItemEgg
implements IColorSource {
    public ItemColoredEgg() {
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(I18n.func_74838_a((String)"item.colored_egg.tooltip"));
    }

    public String func_77653_i(ItemStack stack) {
        EnumDyeColor color = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        String unlocalizedName = color.func_176762_d();
        if (unlocalizedName.equals("silver")) {
            unlocalizedName = unlocalizedName + "Dye";
        }
        return I18n.func_74838_a((String)(this.func_77658_a() + "." + unlocalizedName + ".name"));
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (!chicken.isDye()) continue;
            subItems.add(new ItemStack(itemIn, 1, chicken.getDyeMetadata()));
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return EnumDyeColor.func_176766_a((int)stack.func_77960_j()).func_176768_e().field_76291_p;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        int chickenType;
        if (!playerIn.field_71075_bZ.field_75098_d) {
            --itemStackIn.field_77994_a;
        }
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187511_aA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K && (chickenType = this.getChickenType(itemStackIn)) != -1) {
            EntityColoredEgg entityIn = new EntityColoredEgg(worldIn, (EntityLivingBase)playerIn);
            entityIn.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            entityIn.setChickenType(chickenType);
            worldIn.func_72838_d((Entity)entityIn);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public int getChickenType(ItemStack itemStack) {
        ChickensRegistryItem chicken = ChickensRegistry.findDyeChicken(itemStack.func_77960_j());
        if (chicken == null) {
            return -1;
        }
        return chicken.getId();
    }
}

