/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.util.CustomEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class RewardsUtil {
    private static List<String> oredicts = new ArrayList<String>();
    private static String[] possibleModOres = new String[]{"oreAluminum", "oreCopper", "oreMythril", "oreLead", "orePlutonium", "oreQuartz", "oreRuby", "oreSalt", "oreSapphire", "oreSilver", "oreTin", "oreUranium", "oreZinc"};
    private static List<String> fluids = new ArrayList<String>();
    public static final Random rand = new Random();

    public static List<String> getOreDicts() {
        return oredicts;
    }

    public static List<String> getFluids() {
        return fluids;
    }

    public static void initData() {
        oredicts.add("oreGold");
        oredicts.add("oreIron");
        oredicts.add("oreLapis");
        oredicts.add("oreDiamond");
        oredicts.add("oreRedstone");
        oredicts.add("oreEmerald");
        oredicts.add("oreQuartz");
        oredicts.add("oreCoal");
        for (String oreDict : possibleModOres) {
            if (!OreDictionary.doesOreNameExist((String)oreDict)) continue;
            oredicts.add(oreDict);
        }
        for (String s : FluidRegistry.getRegisteredFluids().keySet()) {
            fluids.add(s);
        }
    }

    public static OffsetBlock[] fillArea(int xSize, int ySize, int zSize, Block block, int xOff, int yOff, int zOff, boolean falling, int delay, boolean causesUpdate, boolean relativeToPlayer) {
        ArrayList<OffsetBlock> toReturn = new ArrayList<OffsetBlock>();
        for (int y = 0; y < ySize; ++y) {
            for (int z = 0; z < zSize; ++z) {
                for (int x = 0; x < xSize; ++x) {
                    toReturn.add(new OffsetBlock(x + xOff, y + yOff, z + zOff, block, falling, delay).setCausesBlockUpdate(causesUpdate).setRelativeToPlayer(relativeToPlayer));
                }
            }
        }
        return toReturn.toArray(new OffsetBlock[toReturn.size()]);
    }

    public static OffsetBlock[] addBlocksLists(OffsetBlock[] ... lists) {
        int size = 0;
        for (OffsetBlock[] list : lists) {
            size += list.length;
        }
        OffsetBlock[] toReturn = new OffsetBlock[size];
        int i = 0;
        OffsetBlock[][] offsetBlockArray = lists;
        int n = offsetBlockArray.length;
        for (int j = 0; j < n; ++j) {
            OffsetBlock[] list;
            OffsetBlock[] offsetBlockArray2 = list = offsetBlockArray[j];
            int n2 = offsetBlockArray2.length;
            for (int k = 0; k < n2; ++k) {
                OffsetBlock osb;
                toReturn[i] = osb = offsetBlockArray2[k];
                ++i;
            }
        }
        return toReturn;
    }

    public static EntityPart[] spawnXEntities(NBTTagCompound entityNbt, int amount) {
        EntityPart[] toReturn = new EntityPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new EntityPart(entityNbt);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static ParticlePart[] spawnXParticles(int particle, int amount) {
        ParticlePart[] toReturn = new ParticlePart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new ParticlePart(particle);
        }
        return toReturn;
    }

    public static ItemPart[] generateItemParts(ItemStack ... stacks) {
        ItemPart[] toReturn = new ItemPart[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            toReturn[i] = new ItemPart(stacks[i]);
        }
        return toReturn;
    }

    public static ItemPart[] generateItemParts(Item ... items) {
        ItemPart[] toReturn = new ItemPart[items.length];
        for (int i = 0; i < items.length; ++i) {
            toReturn[i] = new ItemPart(new ItemStack(items[i]));
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(World world, BlockPos pos, int distance, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            double dist = Math.sqrt(Math.pow((double)pos.func_177958_n() - entityplayer.field_70165_t, 2.0) + Math.pow((double)pos.func_177956_o() - entityplayer.field_70163_u, 2.0) + Math.pow((double)pos.func_177952_p() - entityplayer.field_70161_v, 2.0));
            if (!(dist <= (double)distance)) continue;
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static void sendMessageToAllPlayers(World world, String message) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
            entityplayer.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        return RewardsUtil.getItemStack(mod, itemName, size, 0);
    }

    public static ItemStack getItemStack(String mod, String itemName, int size, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
        return item == null ? null : new ItemStack(item, size, meta);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
    }

    public static IBlockState getBlockStateFromBlockMeta(Block b, int meta) {
        return b.func_176203_a(meta);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos) {
        return RewardsUtil.placeBlock(b, world, pos, 3, false);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos, boolean ignoreUnbreakable) {
        return RewardsUtil.placeBlock(b, world, pos, 3, ignoreUnbreakable);
    }

    public static boolean placeBlock(IBlockState b, World world, BlockPos pos, int update, boolean ignoreUnbreakable) {
        if (!(RewardsUtil.isBlockUnbreakable(world, pos) && !ignoreUnbreakable || CCubesSettings.nonReplaceableBlocks.contains(world.func_180495_p(pos)))) {
            world.func_180501_a(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
    }

    public static Block getRandomBlock() {
        int size = Block.field_149771_c.func_148742_b().size();
        int randomblock = rand.nextInt(size);
        Block b = (Block)Block.field_149771_c.func_148754_a(randomblock);
        int iteration = 0;
        while (b == null) {
            randomblock = rand.nextInt(size);
            if (++iteration > 100) {
                b = Blocks.field_150347_e;
                continue;
            }
            b = (Block)Block.field_149771_c.func_148754_a(randomblock);
        }
        return b;
    }

    public static CustomEntry<Block, Integer> getRandomOre() {
        List ores = OreDictionary.getOres((String)RewardsUtil.getRandomOreDict());
        Block ore = null;
        int meta = 0;
        if (ores.size() == 0) {
            ore = Blocks.field_150365_q;
        } else {
            ItemStack stack = (ItemStack)ores.get(rand.nextInt(ores.size()));
            ore = Block.func_149634_a((Item)stack.func_77973_b());
            meta = stack.func_77952_i();
        }
        return new CustomEntry<Block, Integer>(ore, meta);
    }

    public static Item getRandomItem() {
        Item item = Item.func_150899_d((int)(256 + rand.nextInt(166)));
        while (item == null) {
            item = Item.func_150899_d((int)(256 + rand.nextInt(166)));
        }
        return item;
    }

    public static String getRandomOreDict() {
        return RewardsUtil.getOreDicts().get(rand.nextInt(RewardsUtil.getOreDicts().size()));
    }

    public static Fluid getRandomFluid() {
        Fluid f = FluidRegistry.getFluid((String)RewardsUtil.getFluids().get(rand.nextInt(RewardsUtil.getFluids().size())));
        while (f == null || f.getBlock() == null) {
            f = FluidRegistry.getFluid((String)RewardsUtil.getFluids().get(rand.nextInt(RewardsUtil.getFluids().size())));
        }
        return f;
    }

    public static ItemStack getSpawnEggForMob(String entity) {
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entity);
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    public static boolean isPlayerOnline(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        for (EntityPlayerMP playerMP : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
            if (!playerMP.func_110124_au().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }
}

