/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.type;

import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.type.IRewardType;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SchematicRewardType
implements IRewardType {
    private CustomSchematic schematic;

    public SchematicRewardType(CustomSchematic schematic) {
        this.schematic = schematic;
    }

    @Override
    public void trigger(final World world, final int x, final int y, final int z, EntityPlayer player) {
        final ArrayList<OffsetBlock> stack = new ArrayList<OffsetBlock>();
        for (OffsetBlock osb : this.schematic.getBlocks()) {
            stack.add(osb);
        }
        Scheduler.scheduleTask(new Task("Schematic_Spawn_Delay", this.schematic.getDelay()){

            @Override
            public void callback() {
                Scheduler.scheduleTask(new Task("Schematic_Reward_Block_Spawn", -1, SchematicRewardType.this.schematic.getSpacingDelay() < 1.0f ? 1 : (int)SchematicRewardType.this.schematic.getSpacingDelay()){

                    @Override
                    public void callback() {
                    }

                    @Override
                    public void update() {
                        float lessThan1 = 0.0f;
                        while (lessThan1 < 1.0f && !stack.isEmpty()) {
                            OffsetBlock osb = (OffsetBlock)stack.remove(0);
                            osb.spawnInWorld(world, x, y, z);
                            lessThan1 += SchematicRewardType.this.schematic.getSpacingDelay();
                            if (stack.size() != 0) continue;
                            lessThan1 = 1.0f;
                        }
                        if (stack.size() == 0) {
                            Scheduler.removeTask(this);
                        }
                    }
                });
            }
        });
    }
}

