/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ModDescriptionEnhancer;
import codechicken.core.launch.CodeChickenCorePlugin;
import com.google.common.base.Function;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class CCUpdateChecker {
    private static final ArrayList<String> updates = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71415_G) {
            return;
        }
        ArrayList<String> arrayList = updates;
        synchronized (arrayList) {
            for (String updateMessage : updates) {
                mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(updateMessage));
            }
            updates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpdateMessage(String s) {
        ArrayList<String> arrayList = updates;
        synchronized (arrayList) {
            updates.add(s);
        }
    }

    public static String mcVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    public static void updateCheck(final String mod, final String version) {
        CCUpdateChecker.updateCheck("http://www.chickenbones.net/Files/notification/version.php?version=" + CCUpdateChecker.mcVersion() + "&file=" + mod, new Function<String, Void>(){

            public Void apply(String ret) {
                if (!ret.startsWith("Ret: ")) {
                    CodeChickenCorePlugin.logger.error("Failed to check update for " + mod + " returned: " + ret);
                    return null;
                }
                ComparableVersion newVersion = new ComparableVersion(ret.substring(5));
                if (newVersion.compareTo(new ComparableVersion(version)) > 0) {
                    ModDescriptionEnhancer.setUpdateStatus(mod, ForgeVersion.Status.OUTDATED, newVersion);
                    CCUpdateChecker.addUpdateMessage("Version " + newVersion + " of " + mod + " is available");
                }
                return null;
            }
        });
    }

    public static void updateCheck(String mod) {
        CCUpdateChecker.updateCheck(mod, ((ModContainer)Loader.instance().getIndexedModList().get(mod)).getVersion());
    }

    public static void updateCheck(String url, Function<String, Void> handler) {
        try {
            new ThreadUpdateCheck(new URL(url), handler).start();
        }
        catch (MalformedURLException e) {
            CodeChickenCorePlugin.logger.error("Malformed URL: " + url, (Throwable)e);
        }
    }

    private static class ThreadUpdateCheck
    extends Thread {
        private final URL url;
        private final Function<String, Void> handler;

        public ThreadUpdateCheck(URL url, Function<String, Void> handler) {
            this.url = url;
            this.handler = handler;
            this.setName("CodeChicken Update Checker");
        }

        @Override
        public void run() {
            try {
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                BufferedReader read = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String ret = read.readLine();
                read.close();
                if (ret == null) {
                    ret = "";
                }
                this.handler.apply((Object)ret);
            }
            catch (SocketTimeoutException conn) {
            }
            catch (UnknownHostException conn) {
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }
}

