/*
 * Decompiled with CFR 0.152.
 */
package us.illyohs.itsbecauseuhasnogoodspawn.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import us.illyohs.itsbecauseuhasnogoodspawn.IBuhngs;
import us.illyohs.itsbecauseuhasnogoodspawn.util.Island;

public class IslandHandler {
    private static IslandHandler instance = null;
    private Path islandPath = Paths.get("./config/island.json", new String[0]);
    private Gson gson;
    public HashMap<String, Island> islandMap = new HashMap();

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        BlockPos spawnPos = player.field_70170_p.func_175694_M();
        if (this.islandMap.isEmpty()) {
            this.islandMap.put("spawn", new Island("default_island", null, "spawn_island", spawnPos.func_177958_n(), spawnPos.func_177956_o() + 2, spawnPos.func_177952_p()));
        }
        if (IBuhngs.ModConfig.AutoMakeIsland && !this.islandMap.containsKey(player.func_70005_c_())) {
            ArrayList xPosList = new ArrayList();
            this.islandMap.forEach((p, i) -> xPosList.add(i.getPosX()));
            int maxPosX = (Integer)Collections.max(xPosList);
            this.addToIslandListAndTeleportPlayer(player, "island_" + player.func_70005_c_(), new BlockPos(maxPosX + IBuhngs.ModConfig.distance, spawnPos.func_177956_o(), spawnPos.func_177952_p()));
        }
    }

    @SubscribeEvent
    public void loadIslandList(WorldEvent.Load e) {
        File file = e.getWorld().func_72860_G().func_75765_b();
        this.gson = new Gson();
        try (FileReader reader = new FileReader("./config/island.json");){
            HashMap newIslandMap = (HashMap)this.gson.fromJson((Reader)reader, new TypeToken<HashMap<String, Island>>(){}.getType());
            this.islandMap.clear();
            this.islandMap.putAll(newIslandMap);
            FMLLog.getLogger().info("Found " + this.islandMap.size() + " islands list now loading islands.");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @SubscribeEvent
    public void saveIslandList(WorldEvent.Save e) {
        block29: {
            File confFile = new File(e.getWorld().func_72912_H().func_76065_j() + "/island.json");
            try {
                if (!Files.exists(this.islandPath, new LinkOption[0])) {
                    Files.createFile(this.islandPath, new FileAttribute[0]);
                }
                if (!confFile.exists() && FMLCommonHandler.instance().getSide() == Side.SERVER) {
                    confFile.createNewFile();
                }
                this.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
                try (FileWriter w = new FileWriter("./config/island.json");){
                    this.gson.toJson(this.islandMap, (Appendable)w);
                }
                if (FMLCommonHandler.instance().getSide() != Side.SERVER) break block29;
                w = new FileWriter(confFile);
                var4_5 = null;
                try {
                    this.gson.toJson(this.islandMap, (Appendable)w);
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (w != null) {
                        if (var4_5 != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void addToIslandList(EntityPlayer player, String islandName, BlockPos pos) {
        this.islandMap.put(player.func_70005_c_(), new Island(player.func_70005_c_(), player.func_110124_au(), islandName, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
    }

    public void addToIslandListAndTeleportPlayer(EntityPlayer player, String islandName, BlockPos pos) {
        this.addToIslandList(player, islandName, pos);
        this.createIslandAndTeleport(player, pos);
        player.func_70634_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
        System.out.println(pos);
    }

    public void createIslandAndTeleport(EntityPlayer player, BlockPos pos) {
        if (player.func_184102_h() != null) {
            ICommandManager icm = player.func_130014_f_().func_73046_m().func_71187_D();
            icm.func_71556_a((ICommandSender)player.func_184102_h(), "/platform spawn yunomakegoodmap:" + IBuhngs.ModConfig.platform + " none " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
        }
    }

    public void teleportToPlayerIsland(EntityPlayer player, String islandName) {
        Island island = this.islandMap.get(islandName);
        player.func_70634_a((double)island.getPosX(), (double)island.getPosY(), (double)island.getPosZ());
    }

    public void spawnIslandForPlayer(EntityPlayer player) {
        BlockPos spawnPos = player.func_130014_f_().func_175694_M();
        if (!this.islandMap.containsKey(player.func_70005_c_())) {
            ArrayList xPosList = new ArrayList();
            this.islandMap.forEach((p, i) -> xPosList.add(i.getPosX()));
            int maxPosX = (Integer)Collections.max(xPosList);
            this.addToIslandListAndTeleportPlayer(player, "island_" + player.func_70005_c_(), new BlockPos(maxPosX + IBuhngs.ModConfig.distance, spawnPos.func_177956_o(), spawnPos.func_177952_p()));
        }
        Island island = this.islandMap.get(player.func_70005_c_());
        player.func_70634_a((double)island.getPosX(), (double)island.getPosY(), (double)island.getPosZ());
    }

    public void addIsland(EntityPlayer player) throws Exception {
        if (this.islandMap.containsKey(player.func_70005_c_())) {
            throw new Exception("Player Island already exists");
        }
        this.islandMap.put(player.func_70005_c_(), new Island(player.func_70005_c_(), player.func_110124_au(), "island_" + player.func_70005_c_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
    }
}

