/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.items.backpacks;

import gr8pefish.ironbackpacks.IronBackpacks;
import gr8pefish.ironbackpacks.achievements.IBackpackCraftAchievement;
import gr8pefish.ironbackpacks.achievements.IronBackpacksAchievements;
import gr8pefish.ironbackpacks.api.items.backpacks.ItemIUpgradableITieredBackpack;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.api.register.ItemIBackpackRegistry;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.container.backpack.ContainerBackpack;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.sounds.IronBackpacksSounds;
import gr8pefish.ironbackpacks.util.IronBackpacksConstants;
import gr8pefish.ironbackpacks.util.Logger;
import gr8pefish.ironbackpacks.util.NBTUtils;
import gr8pefish.ironbackpacks.util.TextUtils;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemBackpack
extends ItemIUpgradableITieredBackpack
implements IBackpackCraftAchievement {
    private boolean openAltGui = true;

    public ItemBackpack(String name, int rowLength, int rowCount, int upgradePoints, int additionalPoints, ResourceLocation guiResourceLocation, int guiXSize, int guiYSize, ResourceLocation modelTexture, String specialty) {
        super(name, rowLength, rowCount, upgradePoints, additionalPoints, guiResourceLocation, guiXSize, guiYSize, modelTexture, specialty);
        this.func_77637_a(IronBackpacks.creativeTab);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return UpgradeMethods.hasDamageBarUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(stack));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getFullness(stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                return EnumActionResult.PASS;
            }
            ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(itemstack);
            boolean hasDepthUpgrade = UpgradeMethods.hasDepthUpgrade(upgrades);
            if (UpgradeMethods.hasQuickDepositUpgrade(upgrades)) {
                boolean bl = this.openAltGui = !UpgradeMethods.transferFromBackpackToInventory(player, itemstack, world, pos, side, false);
                if (!hasDepthUpgrade) {
                    return !this.openAltGui ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                }
            } else if (UpgradeMethods.hasQuickDepositPreciseUpgrade(upgrades)) {
                boolean bl = this.openAltGui = !UpgradeMethods.transferFromBackpackToInventory(player, itemstack, world, pos, side, true);
                if (!hasDepthUpgrade) {
                    return !this.openAltGui ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                }
            }
            if (hasDepthUpgrade) {
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, itemstack));
                for (int j = 0; j < container.getInventoryBackpack().func_70302_i_(); ++j) {
                    boolean openAltGuiDepth;
                    ItemStack nestedBackpack = container.getInventoryBackpack().func_70301_a(j);
                    if (nestedBackpack == null || nestedBackpack.func_77973_b() == null || !(nestedBackpack.func_77973_b() instanceof IBackpack)) continue;
                    ArrayList<ItemStack> nestedUpgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(nestedBackpack);
                    if (UpgradeMethods.hasQuickDepositUpgrade(nestedUpgrades)) {
                        boolean bl = openAltGuiDepth = !UpgradeMethods.transferFromBackpackToInventory(player, nestedBackpack, world, pos, side, false);
                        if (openAltGuiDepth) continue;
                        this.openAltGui = false;
                        continue;
                    }
                    if (!UpgradeMethods.hasQuickDepositPreciseUpgrade(nestedUpgrades)) continue;
                    boolean bl = openAltGuiDepth = !UpgradeMethods.transferFromBackpackToInventory(player, nestedBackpack, world, pos, side, true);
                    if (openAltGuiDepth) continue;
                    this.openAltGui = false;
                }
                return !this.openAltGui ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        return this.handleBackpackOpening(itemStack, world, player, hand, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(stack);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(stack);
        if (Keyboard.isKeyDown((int)42)) {
            int additionalPossiblePoints;
            int upgradesUsed = 0;
            for (ItemStack upgradeStack : upgrades) {
                list.add(TextUtils.localizeEffect("item.ironbackpacks.upgrade." + ItemIUpgradeRegistry.getItemUpgrade(upgradeStack).getName(upgradeStack) + ".name", new Object[0]));
                upgradesUsed += ItemIUpgradeRegistry.getItemUpgrade(upgradeStack).getUpgradeCost(upgradeStack);
            }
            if (upgrades.size() > 0) {
                list.add("");
            }
            if (this.getSpecialty(null) != null) {
                list.add(TextUtils.localizeEffect(this.getSpecialty(null), new Object[0]));
            }
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used", upgradesUsed, totalUpgradePoints));
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.alt", UpgradeMethods.getAltGuiUpgradesApplied(upgrades), IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
            if (ConfigHandler.renamingUpgradeRequired) {
                list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.rename", IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
            }
            if ((additionalPossiblePoints = this.getAdditionalUpgradePoints(null)) > 0) {
                int used = IronBackpacksHelper.getAdditionalUpgradesTimesApplied(stack) * ConfigHandler.additionalUpgradePointsIncrease;
                list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.additionalPoints", used, additionalPossiblePoints));
            }
        } else if (totalUpgradePoints > 0) {
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.shift", new Object[0]));
        }
        if (advanced && NBTUtils.hasUUID(stack)) {
            list.add(TextUtils.localize("tooltip.ironbackpacks.uuid", NBTUtils.getUUID(stack)));
        }
    }

    public ActionResult<ItemStack> handleBackpackOpening(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand, boolean knownShift) {
        if (world.field_72995_K) {
            NBTUtils.setUUID(itemStack);
            PlayerWearingBackpackCapabilities.setCurrentBackpack((EntityLivingBase)player, itemStack);
        }
        if (!world.field_72995_K) {
            boolean sneaking;
            NBTUtils.setUUID(itemStack);
            PlayerWearingBackpackCapabilities.setCurrentBackpack((EntityLivingBase)player, itemStack);
            boolean bl = sneaking = knownShift || player.func_70093_af();
            if (!sneaking) {
                int guiId = ItemIBackpackRegistry.getIndexOf((IBackpack)itemStack.func_77973_b());
                player.func_184185_a(IronBackpacksSounds.open_backpack, 1.0f, 1.0f);
                player.openGui((Object)IronBackpacks.instance, guiId, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
            if (this.openAltGui) {
                int guiId = ItemIBackpackRegistry.getIndexOf((IBackpack)itemStack.func_77973_b());
                player.func_184185_a(IronBackpacksSounds.open_backpack, 1.0f, 1.0f);
                player.openGui((Object)IronBackpacks.instance, guiId * -1 - 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                this.openAltGui = true;
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    private double getFullness(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        int total = 0;
        int full = 0;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
            ItemStack[] inventory = new ItemStack[((ItemIUpgradableITieredBackpack)stack.func_77973_b()).getSize(stack)];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte slot = stackTag.func_74771_c("Slot");
                if (i < 0 || i > inventory.length) continue;
                inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
            for (ItemStack tempStack : inventory) {
                if (tempStack != null) {
                    full += tempStack.field_77994_a;
                    total += tempStack.func_77976_d();
                    continue;
                }
                total += 64;
            }
        }
        return 1.0 - (double)full / (double)total;
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        if (stack.func_77973_b() instanceof ItemBackpack) {
            ItemBackpack backpack = (ItemBackpack)stack.func_77973_b();
            switch (backpack.getTier(null)) {
                case 0: {
                    return IronBackpacksAchievements.basicPackCrafted;
                }
                case 1: {
                    return IronBackpacksAchievements.ironPackCrafted;
                }
                case 2: {
                    return IronBackpacksAchievements.goldPackCrafted;
                }
                case 3: {
                    return IronBackpacksAchievements.diamondPackCrafted;
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        try {
            EntityPlayer player = IronBackpacks.proxy.getClientPlayer();
            if (player != null && player.func_146103_bH().getId().equals(UUID.fromString("eb21559e-bb22-46f2-897b-71eee2d5c09b"))) {
                return super.func_77653_i(stack).replaceAll("Backpack", "Snail");
            }
            return super.func_77653_i(stack);
        }
        catch (RuntimeException e) {
            Logger.error("Display name errors found. Report to mod author please.");
            return super.func_77653_i(stack);
        }
    }
}

