/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.entity;

import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBackpack
extends Entity
implements IEntityAdditionalSpawnData {
    private EntityPlayer player;
    private ItemStack backpackStack;
    private static Map<ItemStack, EntityBackpack> backpacksSpawnedMap = new HashMap<ItemStack, EntityBackpack>();

    public EntityBackpack(World world) {
        super(world);
    }

    public EntityBackpack(World world, EntityPlayer player, ItemStack backpackStack) {
        super(world);
        this.player = player;
        this.backpackStack = backpackStack;
    }

    protected void func_70088_a() {
    }

    public static void updatePlayersBackpack(ItemStack stack, EntityBackpack backpack) {
        if (backpacksSpawnedMap.containsKey(stack)) {
            backpacksSpawnedMap.replace(stack, backpacksSpawnedMap.get(stack), backpack);
        } else {
            backpacksSpawnedMap.put(stack, backpack);
        }
    }

    public static void killBackpack(ItemStack stack) {
        if (backpacksSpawnedMap.containsKey(stack) && backpacksSpawnedMap.get(stack) != null) {
            backpacksSpawnedMap.get(stack).func_70106_y();
        }
    }

    public static boolean containsStack(ItemStack stack) {
        return backpacksSpawnedMap.containsKey(stack);
    }

    public static EntityBackpack getEntityBackpack(ItemStack stack) {
        if (backpacksSpawnedMap.containsKey(stack)) {
            return backpacksSpawnedMap.get(stack);
        }
        return null;
    }

    public void func_70106_y() {
        super.func_70106_y();
        backpacksSpawnedMap.remove(this.backpackStack);
    }

    public static boolean isBackpackValid(EntityPlayer player, EntityBackpack backpack) {
        if (player == null || player.field_70128_L || backpack == null || backpack.field_70128_L) {
            return false;
        }
        return player.field_70170_p.field_73011_w.getDimension() == backpack.field_70170_p.field_73011_w.getDimension();
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateBackpacks(Minecraft mc, World worldObj) {
        EntityBackpack pack;
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
        if (backpack != null && (pack = backpacksSpawnedMap.get(backpack)) != null) {
            if (EntityBackpack.isBackpackValid((EntityPlayer)player, pack)) {
                pack.fixPositions((EntityPlayer)player, true);
            } else {
                pack.func_70106_y();
            }
        }
    }

    public void fixPositions(EntityPlayer thePlayer, boolean localPlayer) {
        this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
        this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
        this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
        this.field_70165_t = this.player.field_70165_t;
        this.field_70163_u = this.player.field_70163_u;
        this.field_70161_v = this.player.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70126_B = this.player.field_70760_ar;
        this.field_70177_z = this.player.field_70761_aq;
        this.field_70127_C = this.player.field_70127_C;
        this.field_70125_A = this.player.field_70125_A;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void readSpawnData(ByteBuf data) {
        int playerId = data.readInt();
        Entity e = this.field_70170_p.func_73045_a(playerId);
        if (e instanceof EntityPlayer) {
            this.player = (EntityPlayer)e;
            ItemStack backpack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)this.player);
            backpacksSpawnedMap.put(backpack, this);
        } else {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.player == null) {
            data.writeInt(-42);
        } else {
            data.writeInt(this.player.func_145782_y());
        }
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
    }
}

